/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms.manifest;

import java.math.BigInteger;
import java.text.ParseException;
import java.util.Map;
import java.util.TreeMap;
import net.ripe.rpki.commons.crypto.cms.RpkiSignedObjectInfo;
import net.ripe.rpki.commons.crypto.cms.RpkiSignedObjectParser;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCms;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCmsGeneralInfo;
import net.ripe.rpki.commons.crypto.util.Asn1Util;
import net.ripe.rpki.commons.util.UTC;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.apache.commons.lang3.Validate;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERIA5String;
import org.joda.time.DateTime;

public class ManifestCmsParser
extends RpkiSignedObjectParser {
    private int version = 0;
    private BigInteger number;
    private DateTime thisUpdateTime;
    private DateTime nextUpdateTime;
    private String fileHashAlgorithm;
    private Map<String, byte[]> files;

    @Override
    public void parse(ValidationResult result, byte[] encoded) {
        super.parse(result, encoded);
        if (this.isSuccess()) {
            this.validateManifest();
        }
    }

    public boolean isSuccess() {
        return !this.getValidationResult().hasFailures();
    }

    public ManifestCms getManifestCms() {
        if (!this.isSuccess()) {
            throw new IllegalArgumentException("Manifest validation failed: " + this.getValidationResult().getFailuresForCurrentLocation());
        }
        RpkiSignedObjectInfo cmsObjectData = new RpkiSignedObjectInfo(this.getEncoded(), this.getResourceCertificate(), this.getContentType(), this.getSigningTime());
        ManifestCmsGeneralInfo manifestCmsGeneralInfo = new ManifestCmsGeneralInfo(this.version, this.number, this.thisUpdateTime, this.nextUpdateTime, this.fileHashAlgorithm);
        return new ManifestCms(cmsObjectData, manifestCmsGeneralInfo, this.files);
    }

    private void validateManifest() {
        ValidationResult validationResult = this.getValidationResult();
        validationResult.rejectIfFalse(ManifestCms.CONTENT_TYPE.equals((ASN1Primitive)this.getContentType()), "mf.content.type");
        validationResult.rejectIfFalse(this.getResourceCertificate().isResourceSetInherited(), "mf.resource.inherit");
    }

    void decodeFileAndHash(Map<String, byte[]> result, ASN1Encodable encoded) {
        ASN1Sequence seq = Asn1Util.expect(encoded, ASN1Sequence.class);
        Validate.isTrue((seq.size() == 2 ? 1 : 0) != 0, (String)"der sequence does not contain file and hash", (Object[])new Object[0]);
        DERIA5String derFile = Asn1Util.expect(seq.getObjectAt(0), DERIA5String.class);
        DERBitString derHash = Asn1Util.expect(seq.getObjectAt(1), DERBitString.class);
        result.put(derFile.getString(), derHash.getBytes());
    }

    void decodeFileList(Map<String, byte[]> result, ASN1Encodable encoded) {
        ASN1Sequence seq = Asn1Util.expect(encoded, ASN1Sequence.class);
        boolean errorOccured = false;
        for (int i = 0; i < seq.size(); ++i) {
            try {
                this.decodeFileAndHash(result, seq.getObjectAt(i));
                continue;
            }
            catch (IllegalArgumentException e) {
                errorOccured = true;
                break;
            }
        }
        this.getValidationResult().rejectIfTrue(errorOccured, "mf.decode.filelist");
    }

    @Override
    public void decodeAsn1Content(ASN1Encodable encoded) {
        ValidationResult validationResult = this.getValidationResult();
        try {
            ASN1Sequence seq = Asn1Util.expect(encoded, ASN1Sequence.class);
            int itemCount = seq.size();
            int offset = 0;
            if (itemCount == 6) {
                BigInteger version = ManifestCmsParser.getRpkiObjectVersion(seq);
                validationResult.rejectIfFalse(BigInteger.ZERO.equals(version), "mf.version", "manifest version must be 0, but is " + version);
                ++offset;
            } else if (itemCount == 5) {
                this.version = 0;
            }
            validationResult.rejectIfFalse(itemCount == 5 || itemCount == 6, "mf.content.size");
            if (validationResult.hasFailureForCurrentLocation()) {
                return;
            }
            this.number = Asn1Util.expect(seq.getObjectAt(offset++), ASN1Integer.class).getValue();
            this.thisUpdateTime = UTC.dateTime(Asn1Util.expect(seq.getObjectAt(offset++), ASN1GeneralizedTime.class).getDate().getTime());
            this.nextUpdateTime = UTC.dateTime(Asn1Util.expect(seq.getObjectAt(offset++), ASN1GeneralizedTime.class).getDate().getTime());
            this.fileHashAlgorithm = Asn1Util.expect(seq.getObjectAt(offset++), ASN1ObjectIdentifier.class).getId();
            validationResult.rejectIfFalse(ManifestCms.FILE_HASH_ALGORITHM.equals(this.fileHashAlgorithm), "mf.file.hash.algorithm", this.fileHashAlgorithm);
            this.files = new TreeMap<String, byte[]>();
            this.decodeFileList(this.files, seq.getObjectAt(offset));
        }
        catch (IllegalArgumentException e) {
            validationResult.error("mf.content.structure");
        }
        catch (ParseException e) {
            validationResult.error("mf.time.format");
        }
    }
}

