/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms;

import java.util.Optional;
import net.ripe.rpki.commons.crypto.cms.RpkiSignedObjectParser;
import net.ripe.rpki.commons.crypto.cms.aspa.AspaCms;
import net.ripe.rpki.commons.crypto.cms.ghostbuster.GhostbustersCms;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCms;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCms;
import net.ripe.rpki.commons.util.RepositoryObjectType;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.joda.time.DateTime;

public class GenericRpkiSignedObjectParser
extends RpkiSignedObjectParser {
    @Override
    public DateTime getSigningTime() {
        return super.getSigningTime();
    }

    public Optional<RepositoryObjectType> getRepositoryObjectType() {
        ASN1ObjectIdentifier contentType = this.getContentType();
        if (AspaCms.CONTENT_TYPE.equals((ASN1Primitive)contentType)) {
            return Optional.of(RepositoryObjectType.Aspa);
        }
        if (GhostbustersCms.CONTENT_TYPE.equals((ASN1Primitive)contentType)) {
            return Optional.of(RepositoryObjectType.Gbr);
        }
        if (ManifestCms.CONTENT_TYPE.equals((ASN1Primitive)contentType)) {
            return Optional.of(RepositoryObjectType.Manifest);
        }
        if (RoaCms.CONTENT_TYPE.equals((ASN1Primitive)contentType)) {
            return Optional.of(RepositoryObjectType.Roa);
        }
        return Optional.empty();
    }
}

