/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.validation.properties;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.GeneratorConfiguration;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.URI;

public class URIGen
extends Generator<URI> {
    public static final int HOST_REG_NAME = 0;
    public static final int HOST_IPV4 = 1;
    public static final int HOST_IPV6 = 2;
    private final String UPPERCASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private final String LOWERCASE = "abcdefghijklmnopqrstuvwxyz";
    private final String NUMERIC = "0123456789";
    private String[] schemes;
    private SourceOfRandomness r;

    public URIGen() {
        super(URI.class);
    }

    public URIGen(String[] schemas) {
        super(URI.class);
        this.schemes = schemas;
    }

    public URI generate(SourceOfRandomness r, GenerationStatus generationStatus) {
        this.r = r;
        try {
            return this.buildURI();
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
            return null;
        }
    }

    public void configure(URIControls uriControls) {
        this.schemes = uriControls.schemas();
    }

    private URI buildURI() throws Exception {
        String uri = this.scheme() + this.authority() + this.path() + this.query() + this.fragment();
        return new URI(uri);
    }

    private String scheme() {
        int pickScheme = this.r.nextInt(0, this.schemes.length - 1);
        return this.schemes[pickScheme] + ":";
    }

    private String authority() throws Exception {
        return "//" + this.userinfo() + this.host() + this.port();
    }

    private String userinfo() {
        if (this.r.nextBoolean()) {
            return "";
        }
        String REG = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        return this.randomString(1, 100, REG, false) + ":" + this.randomString(0, 100, REG, false) + "@";
    }

    private String host() throws Exception {
        switch (this.r.nextInt(0, 2)) {
            case 0: {
                return this.regName();
            }
            case 1: {
                return this.ipv4();
            }
            case 2: {
                return this.ipv6();
            }
        }
        throw new Exception("Invalid option for host");
    }

    private String regName() {
        int maxLength = 254;
        String REG = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        String REG_START = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
        boolean noDash = true;
        int numSections = this.r.nextInt(1, 3);
        CharSequence[] sections = new String[numSections];
        for (int i = 0; i < numSections && maxLength > 0; ++i) {
            int sectionMaxLength = Integer.min(20, maxLength - 3);
            sections[i] = this.randomString(1, 1, REG_START, false) + this.randomString(1, sectionMaxLength - 1, REG, false);
            if (!noDash || !this.r.nextBoolean() || (maxLength -= ((String)sections[i]).length()) <= 0 || ((String)sections[i]).length() <= 3) continue;
            int placeDash = this.r.nextInt(1, ((String)sections[i]).length() - 2);
            sections[i] = ((String)sections[i]).substring(0, placeDash) + "-" + ((String)sections[i]).substring(placeDash);
            noDash = false;
            --maxLength;
        }
        return String.join((CharSequence)".", sections);
    }

    private String ipv4() {
        return this.r.nextInt(0, 255) + "." + this.r.nextInt(0, 255) + "." + this.r.nextInt(0, 255) + "." + this.r.nextInt(0, 255);
    }

    private String ipv6() {
        return String.format("[%04X:%04X:%04X:%04X:%04X:%04X:%04X:%04X]", this.r.nextInt(0, 65535), this.r.nextInt(0, 65535), this.r.nextInt(0, 65535), this.r.nextInt(0, 65535), this.r.nextInt(0, 65535), this.r.nextInt(0, 65535), this.r.nextInt(0, 65535), this.r.nextInt(0, 65535));
    }

    private String port() {
        if (this.r.nextBoolean()) {
            return "";
        }
        return ":" + this.r.nextInt(0, 65535);
    }

    private String path() {
        String PATH = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.+;=";
        return "/" + this.randomString(1, 1, PATH, true) + this.randomString(1, 255, PATH + "/", true);
    }

    private String query() {
        if (this.r.nextBoolean()) {
            return "";
        }
        String QUERY = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789/?=";
        return "?" + this.randomString(1, 255, QUERY, true);
    }

    private String fragment() {
        if (this.r.nextBoolean()) {
            return "";
        }
        String FRAGMENT = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789/?=";
        return "#" + this.randomString(1, 255, FRAGMENT, true);
    }

    private String randomString(int minLength, int maxLength, String possibleCharacters, boolean genEncodedChars) {
        String HEX_DIGIT = "0123456789ABCDEF";
        StringBuilder sb = new StringBuilder();
        int len = this.r.nextInt(minLength, maxLength);
        for (int i = 0; i < len; ++i) {
            if (genEncodedChars) {
                int charIdx = this.r.nextInt(0, possibleCharacters.length());
                if (charIdx == possibleCharacters.length()) {
                    sb.append("%").append(this.randomString(2, 2, HEX_DIGIT, false));
                    continue;
                }
                sb.append(possibleCharacters.charAt(charIdx));
                continue;
            }
            sb.append(possibleCharacters.charAt(this.r.nextInt(0, possibleCharacters.length() - 1)));
        }
        return sb.toString();
    }

    @Target(value={ElementType.PARAMETER, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @GeneratorConfiguration
    public static @interface URIControls {
        public String[] schemas();
    }
}

