/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.validation.interop;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.util.CertificateRepositoryObjectFactory;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Test;

public class BBNConformanceTest {
    private static final String PATH_TO_BBN_OBJECTS = "src/test/resources/conformance/";

    @Test
    public void shouldParseAllObjects() throws IOException {
        int objectCount = 0;
        int errorCount = 0;
        int exceptionCount = 0;
        Iterator fileIterator = FileUtils.iterateFiles((File)new File(PATH_TO_BBN_OBJECTS), (String[])new String[]{"cer", "crl", "mft", "roa"}, (boolean)true);
        while (fileIterator.hasNext()) {
            ++objectCount;
            File file = (File)fileIterator.next();
            byte[] encoded = Files.toByteArray((File)file);
            ValidationResult result = ValidationResult.withLocation((String)file.getName());
            try {
                CertificateRepositoryObject res = CertificateRepositoryObjectFactory.createCertificateRepositoryObject((byte[])encoded, (ValidationResult)result);
                Assert.assertTrue((result.hasFailures() || res != null ? 1 : 0) != 0);
                if (result.hasFailures() && file.getName().startsWith("good")) {
                    System.err.println("Supposed to be good: " + file.getName());
                    ++errorCount;
                    continue;
                }
                if (!result.hasFailures() && file.getName().startsWith("bad")) {
                    System.err.println("Supposed to be bad: " + file.getName());
                    ++errorCount;
                    continue;
                }
                System.out.println(file.getName() + " -> " + result.hasFailures());
            }
            catch (RuntimeException ex) {
                System.err.println("Exception while parsing " + file.getName());
                ++exceptionCount;
            }
        }
        System.out.println(objectCount + " objects: " + errorCount + " errors, " + exceptionCount + " exceptions");
    }
}

