/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.rfc3779;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Optional;
import net.ripe.ipresource.ImmutableResourceSet;
import net.ripe.ipresource.IpResourceType;
import net.ripe.rpki.commons.crypto.rfc3779.ResourceExtension;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class ResourceExtensionTest {
    @Test
    public void should_enforce_non_empty_resource_extension() {
        Assertions.assertThatThrownBy(() -> ResourceExtension.ofResources((ImmutableResourceSet)ImmutableResourceSet.empty())).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> ResourceExtension.ofInherited(EnumSet.noneOf(IpResourceType.class))).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void mapResources() {
        Assertions.assertThat((Optional)ResourceExtension.ofResources((ImmutableResourceSet)ImmutableResourceSet.ALL_PRIVATE_USE_RESOURCES).mapResources(ignored -> ImmutableResourceSet.empty())).isEmpty();
        Assertions.assertThat((Optional)ResourceExtension.allInherited().mapResources(ignored -> ImmutableResourceSet.empty())).hasValueSatisfying(re -> {
            Assertions.assertThat((Collection)re.getInheritedResourceTypes()).containsExactly((Object[])IpResourceType.values());
            Assertions.assertThat((Iterable)re.getResources()).isEqualTo((Object)ImmutableResourceSet.empty());
        });
        Assertions.assertThat((Optional)ResourceExtension.ofResources((ImmutableResourceSet)ImmutableResourceSet.ALL_PRIVATE_USE_RESOURCES).mapResources(r -> r.intersection(ImmutableResourceSet.parse((String)"192.0.0.0/8")))).hasValueSatisfying(re -> {
            Assertions.assertThat((Iterable)re.getResources()).isEqualTo((Object)ImmutableResourceSet.parse((String)"192.168.0.0/16"));
            Assertions.assertThat((boolean)re.isResourceSetInherited()).isFalse();
        });
    }
}

