/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms.roa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import net.ripe.ipresource.IpRange;
import net.ripe.rpki.commons.crypto.cms.roa.RoaPrefix;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class RoaPrefixTest {
    @Test
    public void shouldSortRoaPrefixByPrefixThenMaximumLength() {
        RoaPrefix p1 = new RoaPrefix(IpRange.parse((String)"10.0.0.0/8"));
        RoaPrefix p2 = new RoaPrefix(IpRange.parse((String)"11.0.0.0/8"));
        RoaPrefix p2_8 = new RoaPrefix(IpRange.parse((String)"11.0.0.0/8"), Integer.valueOf(8));
        RoaPrefix p2_24 = new RoaPrefix(IpRange.parse((String)"11.0.0.0/8"), Integer.valueOf(24));
        ArrayList<RoaPrefix> prefixList = new ArrayList<RoaPrefix>(List.of(p2_24, p1, p2_8, p2));
        Assertions.assertThat(new TreeSet<RoaPrefix>(List.of(p2_24, p1, p2_8, p2))).containsExactly(new Object[]{p1, p2, p2_8, p2_24});
        for (int i = 0; i < 16; ++i) {
            Collections.shuffle(prefixList);
            Assertions.assertThat(new TreeSet<RoaPrefix>(prefixList)).containsExactly(new Object[]{p1, p2, p2_8, p2_24});
        }
    }

    @Test
    public void shouldEnsureIpAddressIsValidPrefix() {
        new RoaPrefix(IpRange.parse((String)"10.0.0.0/8"), null);
        try {
            new RoaPrefix(IpRange.parse((String)"10.0.0.0-10.0.2.1"), null);
            org.junit.jupiter.api.Assertions.fail((String)"ROA prefix requires legal prefix");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void shouldEnsureMaximumLengthValidity() {
        new RoaPrefix(IpRange.parse((String)"10.0.0.0/8"), null);
        try {
            new RoaPrefix(IpRange.parse((String)"10.0.0.0/8"), Integer.valueOf(-1));
            org.junit.jupiter.api.Assertions.fail((String)"maximum length invalid");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        new RoaPrefix(IpRange.parse((String)"10.0.0.0/8"), Integer.valueOf(8));
        new RoaPrefix(IpRange.parse((String)"10.0.0.0/8"), Integer.valueOf(17));
        new RoaPrefix(IpRange.parse((String)"10.0.0.0/8"), Integer.valueOf(32));
        new RoaPrefix(IpRange.parse((String)"ffe0::/16"), Integer.valueOf(128));
        try {
            new RoaPrefix(IpRange.parse((String)"10.0.0.0/8"), Integer.valueOf(0));
            org.junit.jupiter.api.Assertions.fail((String)"maximum length invalid");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new RoaPrefix(IpRange.parse((String)"10.0.0.0/8"), Integer.valueOf(7));
            org.junit.jupiter.api.Assertions.fail((String)"maximum length invalid");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new RoaPrefix(IpRange.parse((String)"10.0.0.0/8"), Integer.valueOf(33));
            org.junit.jupiter.api.Assertions.fail((String)"maximum length invalid");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new RoaPrefix(IpRange.parse((String)"ffe0::/16"), Integer.valueOf(129));
            org.junit.jupiter.api.Assertions.fail((String)"maximum length invalid");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

