/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms.roa;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCms;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCmsBuilder;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCmsParserTest;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCmsTest;
import net.ripe.rpki.commons.crypto.cms.roa.RoaPrefix;
import net.ripe.rpki.commons.crypto.rfc3779.AddressFamily;
import net.ripe.rpki.commons.crypto.util.Asn1UtilTest;
import net.ripe.rpki.commons.crypto.util.KeyPairFactoryTest;
import org.bouncycastle.asn1.ASN1Encodable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RoaCmsBuilderTest {
    private List<RoaPrefix> ipv4Prefixes;
    private List<RoaPrefix> allPrefixes;
    private RoaCmsBuilder subject;

    @Before
    public void setUp() {
        this.ipv4Prefixes = new ArrayList<RoaPrefix>();
        this.ipv4Prefixes.add(RoaCmsParserTest.TEST_IPV4_PREFIX_1);
        this.ipv4Prefixes.add(RoaCmsParserTest.TEST_IPV4_PREFIX_2);
        this.allPrefixes = new ArrayList<RoaPrefix>(this.ipv4Prefixes);
        this.allPrefixes.add(RoaCmsParserTest.TEST_IPV6_PREFIX);
        this.subject = new RoaCmsBuilder();
        this.subject.withCertificate(RoaCmsTest.createCertificate(this.allPrefixes));
        this.subject.withAsn(RoaCmsParserTest.TEST_ASN);
        this.subject.withPrefixes(this.allPrefixes);
        this.subject.withSignatureProvider("SunRsaSign");
    }

    @Test
    public void shouldGenerateRoaCms() {
        RoaCms result = this.subject.build(KeyPairFactoryTest.TEST_KEY_PAIR.getPrivate());
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.getEncoded());
    }

    @Test
    public void shouldEncodeRoaIpAddress() {
        Asn1UtilTest.assertEncoded(RoaCmsParserTest.ENCODED_ROA_IP_ADDRESS, (ASN1Encodable)this.subject.encodeRoaIpAddress(RoaCmsParserTest.TEST_IPV4_PREFIX_1));
        Asn1UtilTest.assertEncoded(RoaCmsParserTest.ENCODED_ROA_IP_ADDRESS_2, (ASN1Encodable)this.subject.encodeRoaIpAddress(RoaCmsParserTest.TEST_IPV4_PREFIX_2));
    }

    @Test
    public void shouldEncodeRoaIpAddressFamily() {
        Asn1UtilTest.assertEncoded(RoaCmsParserTest.ENCODED_ROA_IP_ADDRESS_FAMILY, this.subject.encodeRoaIpAddressFamily(AddressFamily.IPV4, Set.copyOf(this.ipv4Prefixes)));
    }

    @Test
    public void shouldEncodeRoaIpAddressFamilySequence() {
        Asn1UtilTest.assertEncoded(RoaCmsParserTest.ENCODED_ROA_IP_ADDRESS_FAMILY_SEQUENCE_IPV4, this.subject.encodeRoaIpAddressFamilySequence(this.ipv4Prefixes));
        Asn1UtilTest.assertEncoded(RoaCmsParserTest.ENCODED_ROA_IP_ADDRESS_FAMILY_SEQUENCE_ALL, this.subject.encodeRoaIpAddressFamilySequence(this.allPrefixes));
    }

    @Test
    public void shouldEncodeRouteOriginAttestation() {
        Assert.assertArrayEquals((byte[])RoaCmsParserTest.ENCODED_ROUTE_ORIGIN_ATTESTATION, (byte[])this.subject.encodeRouteOriginAttestation(RoaCmsParserTest.TEST_ASN, this.ipv4Prefixes));
    }
}

