/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.x509cert;

import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.EnumSet;
import net.ripe.ipresource.ImmutableResourceSet;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.ipresource.IpResourceType;
import net.ripe.rpki.commons.crypto.crl.CrlLocator;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.rfc3779.ResourceExtension;
import net.ripe.rpki.commons.crypto.rfc3779.ResourceExtensionParser;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateInformationAccessDescriptor;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateObject;
import net.ripe.rpki.commons.crypto.x509cert.X509GenericCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateParser;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationOptions;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import net.ripe.rpki.commons.validation.objectvalidators.ResourceValidatorFactory;
import net.ripe.rpki.commons.validation.objectvalidators.X509ResourceCertificateValidator;

public class X509ResourceCertificate
extends X509GenericCertificate
implements X509CertificateObject {
    private static final long serialVersionUID = 3L;
    private final ResourceExtension resourceExtension;
    private Boolean revoked;

    protected X509ResourceCertificate(X509Certificate certificate) {
        super(certificate);
        ResourceExtensionParser parser = new ResourceExtensionParser();
        this.resourceExtension = parser.parse(certificate);
    }

    public ResourceExtension getResourceExtension() {
        return this.resourceExtension;
    }

    public ImmutableResourceSet resources() {
        return this.resourceExtension.getResources();
    }

    public IpResourceSet getResources() {
        return new IpResourceSet(this.resources());
    }

    public EnumSet<IpResourceType> getInheritedResourceTypes() {
        return this.resourceExtension.getInheritedResourceTypes();
    }

    public boolean isResourceTypesInherited(EnumSet<IpResourceType> resourceTypes) {
        return this.resourceExtension.isResourceTypesInherited(resourceTypes);
    }

    public boolean isResourceSetInherited() {
        return this.resourceExtension.isResourceSetInherited();
    }

    @Override
    public URI getCrlUri() {
        return this.findFirstRsyncCrlDistributionPoint();
    }

    @Override
    public URI getParentCertificateUri() {
        return this.findFirstAuthorityInformationAccessByMethod(X509CertificateInformationAccessDescriptor.ID_CA_CA_ISSUERS);
    }

    public void validate(String location, X509ResourceCertificateValidator validator) {
        X509ResourceCertificateParser parser = new X509ResourceCertificateParser();
        parser.parse(ValidationResult.withLocation(location), this.getEncoded());
        if (parser.getValidationResult().hasFailures()) {
            return;
        }
        validator.validate(location, this);
    }

    @Override
    public void validate(String location, CertificateRepositoryObjectValidationContext context, CrlLocator crlLocator, ValidationOptions options, ValidationResult result) {
        X509Crl crl = null;
        if (!this.isRoot()) {
            ValidationLocation savedCurrentLocation = result.getCurrentLocation();
            result.setLocation(new ValidationLocation(this.getCrlUri()));
            crl = crlLocator.getCrl(this.getCrlUri(), context, result);
            result.setLocation(savedCurrentLocation);
            if (crl == null) {
                result.rejectIfFalse(false, "objects.crl.valid", this.getCrlUri().toString());
                return;
            }
        }
        X509ResourceCertificateValidator validator = ResourceValidatorFactory.getX509ResourceCertificateValidator(context, options, result, crl);
        validator.validate(location, this);
        this.revoked = this.hasErrorInRevocationCheck(result.getFailures(new ValidationLocation(location)));
    }

    @Override
    public void validate(String location, CertificateRepositoryObjectValidationContext context, X509Crl crl, URI crlUri, ValidationOptions options, ValidationResult result) {
        if (!this.isRoot() && crl == null) {
            result.rejectIfFalse(false, "objects.crl.valid", crlUri.toString());
            return;
        }
        X509ResourceCertificateValidator validator = ResourceValidatorFactory.getX509ResourceCertificateValidator(context, options, result, crl);
        validator.validate(location, this);
        this.revoked = this.hasErrorInRevocationCheck(result.getFailures(new ValidationLocation(location)));
    }

    @Override
    public boolean isPastValidityTime() {
        return this.getValidityPeriod().isExpiredNow();
    }

    @Override
    public boolean isRevoked() {
        if (this.revoked == null) {
            throw new IllegalStateException("isRevoked() could only be called after validate()");
        }
        return this.revoked;
    }

    public IpResourceSet deriveResources(IpResourceSet parentResources) {
        return new IpResourceSet(this.resourceExtension.deriveResources(ImmutableResourceSet.of((IpResourceSet)parentResources)));
    }

    public ImmutableResourceSet deriveResources(ImmutableResourceSet parentResources) {
        return this.resourceExtension.deriveResources(parentResources);
    }

    public boolean containsResources(IpResourceSet that) {
        return this.resourceExtension.containsResources(that);
    }

    public boolean containsResources(ImmutableResourceSet that) {
        return this.resourceExtension.containsResources(that);
    }
}

