/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms.roa;

import java.io.Serializable;
import javax.annotation.CheckForNull;
import net.ripe.ipresource.IpRange;
import net.ripe.rpki.commons.util.EqualsSupport;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class RoaPrefix
extends EqualsSupport
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final IpRange prefix;
    @CheckForNull
    private final Integer maximumLength;

    public RoaPrefix(IpRange prefix) {
        this(prefix, null);
    }

    public RoaPrefix(IpRange prefix, Integer maximumLength) {
        Validate.notNull((Object)prefix, (String)"prefix is required", (Object[])new Object[0]);
        Validate.isTrue((boolean)prefix.isLegalPrefix(), (String)"prefix is not a legal prefix", (Object[])new Object[0]);
        Validate.isTrue((maximumLength == null || maximumLength >= prefix.getPrefixLength() && maximumLength <= prefix.getType().getBitSize() ? 1 : 0) != 0, (String)"maximum length not in range", (Object[])new Object[0]);
        this.prefix = prefix;
        this.maximumLength = maximumLength;
    }

    public IpRange getPrefix() {
        return this.prefix;
    }

    public Integer getMaximumLength() {
        return this.maximumLength;
    }

    public int getEffectiveMaximumLength() {
        return this.maximumLength != null ? this.maximumLength.intValue() : this.getPrefix().getPrefixLength();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("prefix", (Object)this.getPrefix()).append("maximumLength", (Object)this.maximumLength).toString();
    }
}

