/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.payload.revocation.response;

import java.io.IOException;
import java.security.PublicKey;
import java.util.regex.Pattern;
import net.ripe.rpki.commons.crypto.util.KeyPairUtil;
import net.ripe.rpki.commons.provisioning.ProvisioningObjectMother;
import net.ripe.rpki.commons.provisioning.payload.RelaxNgSchemaValidator;
import net.ripe.rpki.commons.provisioning.payload.revocation.CertificateRevocationKeyElement;
import net.ripe.rpki.commons.provisioning.payload.revocation.response.CertificateRevocationResponsePayload;
import net.ripe.rpki.commons.provisioning.payload.revocation.response.CertificateRevocationResponsePayloadBuilder;
import net.ripe.rpki.commons.provisioning.payload.revocation.response.CertificateRevocationResponsePayloadSerializer;
import net.ripe.rpki.commons.xml.XmlSerializer;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

public class CertificateRevocationResponsePayloadBuilderSerializerTest {
    private static final XmlSerializer<CertificateRevocationResponsePayload> SERIALIZER = new CertificateRevocationResponsePayloadSerializer();
    public static final CertificateRevocationResponsePayload TEST_CERTIFICATE_REVOCATION_RESPONSE_PAYLOAD = CertificateRevocationResponsePayloadBuilderSerializerTest.createCertificateRevocationResponsePayload();

    public static CertificateRevocationResponsePayload createCertificateRevocationResponsePayload() {
        CertificateRevocationResponsePayloadBuilder builder = new CertificateRevocationResponsePayloadBuilder();
        builder.withClassName("a classname");
        builder.withPublicKey(ProvisioningObjectMother.X509_CA.getPublicKey());
        return builder.build();
    }

    @Test
    public void shouldBuildValidRevocationCms() {
        Assert.assertEquals((Object)"sender", (Object)TEST_CERTIFICATE_REVOCATION_RESPONSE_PAYLOAD.getSender());
        Assert.assertEquals((Object)"recipient", (Object)TEST_CERTIFICATE_REVOCATION_RESPONSE_PAYLOAD.getRecipient());
        CertificateRevocationKeyElement payloadContent = TEST_CERTIFICATE_REVOCATION_RESPONSE_PAYLOAD.getKeyElement();
        Assert.assertEquals((Object)"a classname", (Object)payloadContent.getClassName());
        Assert.assertEquals((Object)KeyPairUtil.getEncodedKeyIdentifier((PublicKey)ProvisioningObjectMother.X509_CA.getPublicKey()), (Object)payloadContent.getPublicKeyHash());
    }

    @Test
    public void shouldProduceXmlConformStandard() {
        String actualXml = SERIALIZER.serialize((Object)TEST_CERTIFICATE_REVOCATION_RESPONSE_PAYLOAD);
        Pattern expectedXmlRegex = Pattern.compile("<\\?xml version=\"1.0\" encoding=\"UTF-8\"\\?>\n<message\\s+xmlns=\"http://www.apnic.net/specs/rescerts/up-down/\"\\s+recipient=\"recipient\"\\s+sender=\"sender\"\\s+type=\"revoke_response\"\\s+version=\"1\">\n   <key\\s+class_name=\"a classname\"\\s+ski=\"[^\"]*\"/>\n</message>\n", 32);
        Assert.assertTrue((String)("actual xml: " + actualXml), (boolean)expectedXmlRegex.matcher(actualXml).matches());
    }

    @Test
    public void shouldDeserializeXml() {
        String actualXml = SERIALIZER.serialize((Object)TEST_CERTIFICATE_REVOCATION_RESPONSE_PAYLOAD);
        CertificateRevocationResponsePayload deserialized = (CertificateRevocationResponsePayload)SERIALIZER.deserialize(actualXml);
        Assert.assertEquals((Object)TEST_CERTIFICATE_REVOCATION_RESPONSE_PAYLOAD, (Object)deserialized);
    }

    @Test
    public void shouldProduceSchemaValidatedXml() throws SAXException, IOException {
        String actualXml = SERIALIZER.serialize((Object)TEST_CERTIFICATE_REVOCATION_RESPONSE_PAYLOAD);
        Assert.assertTrue((boolean)RelaxNgSchemaValidator.validateAgainstRelaxNg(actualXml));
    }
}

