/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.interop;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCmsParser;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class FailingAfrinicRoaTest {
    private static final String PATH_TO_OBJECTS = "src/test/resources/interop/misc-objects";

    @Test
    public void shouldParseAfrinicRoaWithSigningTimeOutsideOfCertificateValidityTime() throws IOException {
        byte[] encoded = Files.toByteArray((File)new File("src/test/resources/interop/misc-objects/6C76EDB2225D11E286C4BD8F7A2F2747.roa"));
        String location = "afrinic.roa";
        ValidationResult result = ValidationResult.withLocation((String)location);
        RoaCmsParser roaParser = new RoaCmsParser();
        roaParser.parse(result, encoded);
        Assertions.assertThat(result.getFailuresForAllLocations().stream().filter(failure -> !failure.getKey().equals("cms.signed.attrs.correct"))).isEmpty();
    }
}

