/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms.aspa;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.StreamSupport;
import javax.annotation.CheckForNull;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpResource;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.rpki.commons.crypto.cms.RpkiSignedObjectInfo;
import net.ripe.rpki.commons.crypto.cms.RpkiSignedObjectParser;
import net.ripe.rpki.commons.crypto.cms.aspa.AspaCms;
import net.ripe.rpki.commons.crypto.cms.aspa.ProviderAS;
import net.ripe.rpki.commons.crypto.rfc3779.AddressFamily;
import net.ripe.rpki.commons.crypto.util.Asn1Util;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class AspaCmsParser
extends RpkiSignedObjectParser {
    private int version;
    @CheckForNull
    private Asn customerAsn;
    private ImmutableSortedSet<ProviderAS> providerASSet = ImmutableSortedSet.of();

    @Override
    public void parse(ValidationResult result, byte[] encoded) {
        super.parse(result, encoded);
        this.validateAspa();
    }

    public AspaCms getAspa() {
        if (!this.isSuccess()) {
            throw new IllegalArgumentException("ASPA record validation failed: " + this.getValidationResult().getFailuresForCurrentLocation());
        }
        RpkiSignedObjectInfo cmsObjectData = new RpkiSignedObjectInfo(this.getEncoded(), this.getResourceCertificate(), this.getContentType(), this.getSigningTime());
        return new AspaCms(cmsObjectData, this.version, this.customerAsn, this.providerASSet);
    }

    public boolean isSuccess() {
        return !this.getValidationResult().hasFailureForCurrentLocation();
    }

    private void validateAspa() {
        ValidationResult validationResult = this.getValidationResult();
        validationResult.rejectIfFalse(AspaCms.CONTENT_TYPE.equals((ASN1Primitive)this.getContentType()), "aspa.content.type", String.valueOf(this.getContentType()));
        X509ResourceCertificate resourceCertificate = this.getCertificate();
        validationResult.rejectIfFalse(this.customerAsn != null && resourceCertificate != null && resourceCertificate.containsResources(new IpResourceSet(new IpResource[]{this.customerAsn})), "aspa.customer.asn.certified");
        if (this.customerAsn != null) {
            boolean providerAsInCustomerAs = this.providerASSet.stream().map(ProviderAS::getProviderAsn).anyMatch(arg_0 -> ((Asn)this.customerAsn).equals(arg_0));
            validationResult.rejectIfTrue(providerAsInCustomerAs, "aspa.customer.asn.ne.provider.asn", String.valueOf(this.customerAsn), Joiner.on((String)", ").join(this.providerASSet));
        }
    }

    @Override
    public void decodeAsn1Content(ASN1Encodable content) {
        ValidationResult validationResult = this.getValidationResult();
        try {
            ASN1Sequence seq = Asn1Util.expect(content, ASN1Sequence.class);
            int itemCount = seq.size();
            if (itemCount < 2 || itemCount > 3) {
                validationResult.error("aspa.content.structure");
                return;
            }
            int index = 0;
            ASN1Encodable maybeVersion = seq.getObjectAt(index);
            if (maybeVersion instanceof DERTaggedObject) {
                this.decodeVersion(validationResult, (DERTaggedObject)maybeVersion);
                ++index;
            } else {
                this.version = 0;
            }
            validationResult.rejectIfFalse(index < itemCount && seq.getObjectAt(index) instanceof ASN1Integer, "aspa.customer.asn.present");
            if (validationResult.hasFailureForCurrentLocation()) {
                return;
            }
            this.customerAsn = Asn1Util.parseAsId(seq.getObjectAt(index));
            if (++index >= itemCount) {
                validationResult.error("aspa.content.structure");
                return;
            }
            ASN1Sequence providerAsnsSequence = Asn1Util.expect(seq.getObjectAt(index), ASN1Sequence.class);
            this.providerASSet = (ImmutableSortedSet)StreamSupport.stream(providerAsnsSequence.spliterator(), false).map(this::parseProviderAS).collect(ImmutableSortedSet.toImmutableSortedSet(Comparator.naturalOrder()));
            validationResult.rejectIfTrue(this.providerASSet.isEmpty(), "aspa.provider.as.set.not.empty");
        }
        catch (IllegalArgumentException ex) {
            validationResult.error("aspa.content.structure");
        }
    }

    private void decodeVersion(ValidationResult validationResult, DERTaggedObject tagged) {
        validationResult.rejectIfFalse(tagged.getTagNo() == 0, "aspa.content.structure");
        try {
            this.version = Asn1Util.expect((ASN1Encodable)tagged.getBaseObject(), ASN1Integer.class).intValueExact();
            validationResult.rejectIfFalse(this.version == 0, "aspa.version", String.valueOf(this.version));
        }
        catch (ArithmeticException e) {
            validationResult.error("aspa.version", "out-of-bounds");
        }
    }

    private ProviderAS parseProviderAS(ASN1Encodable asn1Encodable) {
        ValidationResult validationResult = this.getValidationResult();
        ASN1Sequence sequence = Asn1Util.expect(asn1Encodable, ASN1Sequence.class);
        validationResult.rejectIfTrue(sequence.size() < 1 || sequence.size() > 2, "aspa.provider.as.sequence.size");
        if (validationResult.hasFailureForCurrentLocation()) {
            throw new IllegalArgumentException("invalid sequence length");
        }
        Asn providerAsn = Asn1Util.parseAsId(sequence.getObjectAt(0));
        AddressFamily afiLimit = null;
        if (sequence.size() > 1) {
            afiLimit = AddressFamily.fromDer(sequence.getObjectAt(1));
            validationResult.rejectIfFalse(afiLimit.equals(AddressFamily.IPV4) || afiLimit.equals(AddressFamily.IPV6), "aspa.address.family");
        }
        return new ProviderAS(providerAsn, Optional.ofNullable(afiLimit));
    }
}

