/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.cms;

import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import net.ripe.rpki.commons.provisioning.ProvisioningObjectMother;
import net.ripe.rpki.commons.provisioning.cms.ProvisioningCmsObject;
import net.ripe.rpki.commons.provisioning.cms.ProvisioningCmsObjectParser;
import net.ripe.rpki.commons.provisioning.cms.ProvisioningCmsObjectParserException;
import net.ripe.rpki.commons.validation.ValidationCheck;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.assertj.core.api.Assertions;
import org.joda.time.DateTime;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

public class ProvisioningCmsObjectParserTest {
    private ProvisioningCmsObjectParser subject;

    @BeforeEach
    public void setUp() {
        this.subject = new ProvisioningCmsObjectParser();
    }

    @Test
    public void shouldParseValidObject() {
        ProvisioningCmsObject cmsObject = ProvisioningObjectMother.createResourceClassListQueryProvisioningCmsObject();
        this.subject.parseCms("test-location", cmsObject.getEncoded());
        ValidationResult validationResult = this.subject.getValidationResult();
        Assertions.assertThat((boolean)validationResult.hasFailures()).isFalse();
        Assertions.assertThat((Object)this.subject.getProvisioningCmsObject()).isEqualTo((Object)cmsObject);
    }

    @CsvSource(value={"isc-interop-updown/pdu.170.der", "isc-interop-updown/pdu.171.der", "isc-interop-updown/pdu.172.der", "isc-interop-updown/pdu.173.der", "isc-interop-updown/pdu.180.der", "isc-interop-updown/pdu.183.der", "isc-interop-updown/pdu.184.der", "isc-interop-updown/pdu.189.der", "isc-interop-updown/pdu.196.der", "isc-interop-updown/pdu.199.der", "isc-interop-updown/pdu.200.der", "isc-interop-updown/pdu.205.der"})
    @ParameterizedTest(name="{displayName} - {0}")
    public void shouldParseInteropObjects(String interopFileName) throws IOException {
        byte[] object = Resources.toByteArray((URL)Resources.getResource((String)interopFileName));
        this.subject.parseCms(interopFileName, object);
        Assertions.assertThat((boolean)this.subject.getValidationResult().hasFailures()).isFalse();
        Assertions.assertThat((Comparable)this.subject.getProvisioningCmsObject().getSigningTime()).isBetween((Comparable)DateTime.parse((String)"2011-07-01T00:00:00Z"), (Comparable)DateTime.parse((String)"2011-08-01T00:00:00Z"));
    }

    @Test
    public void shouldFailOnInvalidObject() {
        this.subject.parseCms("test-location", new byte[]{0});
        ValidationResult validationResult = this.subject.getValidationResult();
        Assertions.assertThat((boolean)validationResult.hasFailures()).isTrue();
        Assertions.assertThat((Collection)validationResult.getFailuresForCurrentLocation()).hasSize(1);
        Assertions.assertThat((String)((ValidationCheck)validationResult.getFailuresForCurrentLocation().iterator().next()).getKey()).isEqualTo("cms.signed.data.parsing");
        Assertions.assertThatThrownBy(() -> this.subject.getProvisioningCmsObject()).isInstanceOf(ProvisioningCmsObjectParserException.class);
    }
}

