/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.xml.converters;

import com.thoughtworks.xstream.converters.SingleValueConverter;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class DateTimeConverter
implements SingleValueConverter {
    private static final DateTimeFormatter FORMATTER_DATE_TIME_WITH_MILLIS_AND_ZONE = ISODateTimeFormat.dateTime().withZone(DateTimeZone.UTC);
    private static final DateTimeFormatter FORMATTER_DATE_TIME_NO_MILLIS_AND_ZONE = ISODateTimeFormat.dateTimeNoMillis().withZone(DateTimeZone.UTC);
    private boolean useMillis = false;

    public DateTimeConverter() {
    }

    public DateTimeConverter(boolean useMillis) {
        this.useMillis = useMillis;
    }

    public boolean canConvert(Class type) {
        return DateTime.class.equals((Object)type);
    }

    public Object fromString(String s) {
        try {
            return FORMATTER_DATE_TIME_WITH_MILLIS_AND_ZONE.parseDateTime(s);
        }
        catch (IllegalArgumentException e) {
            return FORMATTER_DATE_TIME_NO_MILLIS_AND_ZONE.parseDateTime(s);
        }
    }

    public String toString(Object datetime) {
        DateTime dateTimeWithZone = ((DateTime)datetime).withZone(DateTimeZone.UTC);
        if (this.useMillis) {
            return FORMATTER_DATE_TIME_WITH_MILLIS_AND_ZONE.print((ReadableInstant)dateTimeWithZone);
        }
        return FORMATTER_DATE_TIME_NO_MILLIS_AND_ZONE.print((ReadableInstant)dateTimeWithZone);
    }
}

