/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.xml;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.ripe.rpki.commons.xml.DomXmlSerializerException;
import net.ripe.rpki.commons.xml.XmlSerializer;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class DomXmlSerializer<T>
implements XmlSerializer<T> {
    protected final String xmlns;

    protected DomXmlSerializer(String xmlns) {
        this.xmlns = xmlns;
    }

    protected String getRequiredAttributeValue(Element node, String attr) {
        return this.getAttributeValue(node, attr).orElseThrow(() -> {
            throw new DomXmlSerializerException(String.format("attribute '%s' not found", attr));
        });
    }

    protected Optional<String> getAttributeValue(Element node, String attr) {
        return node.hasAttribute(attr) ? Optional.of(node.getAttribute(attr)) : Optional.empty();
    }

    protected Optional<Element> getElement(Document doc, String elementName) {
        Element node = (Element)doc.getElementsByTagNameNS(this.xmlns, elementName).item(0);
        return Optional.ofNullable(node);
    }

    protected Element getSingleChildElement(Element parent, String tagName) {
        NodeList nodeList = parent.getElementsByTagNameNS(this.xmlns, tagName);
        if (nodeList.getLength() != 1) {
            throw new DomXmlSerializerException(String.format(nodeList.getLength() == 0 ? "single element '%s' not found" : "multiple elements '%s' present, single element expected", tagName));
        }
        return (Element)nodeList.item(0);
    }

    protected Optional<Element> getOptionalSingleChildElement(Element parent, String tagName) {
        NodeList nodeList = parent.getElementsByTagNameNS(this.xmlns, tagName);
        if (nodeList.getLength() == 0) {
            return Optional.empty();
        }
        return Optional.of(this.getSingleChildElement(parent, tagName));
    }

    protected List<Element> getChildElements(Element parent, String tagName) {
        NodeList nodeList = parent.getElementsByTagNameNS(this.xmlns, tagName);
        ArrayList<Element> result = new ArrayList<Element>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            result.add((Element)nodeList.item(i));
        }
        return result;
    }

    @Override
    protected String serialize(Document document) throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        StringWriter sw = new StringWriter();
        transformer.transform(new DOMSource(document), new StreamResult(sw));
        return sw.toString();
    }

    public Element addChild(Document doc, Node parent, String childName) {
        Element child = doc.createElement(childName);
        parent.appendChild(child);
        return child;
    }

    protected String getElementTextContent(Element element) {
        try {
            return element.getTextContent();
        }
        catch (DOMException e) {
            throw new DomXmlSerializerException("Error reading " + element.getLocalName() + " content", e);
        }
    }
}

