/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.ripe.rpki.commons.crypto.cms.RpkiSignedObject;
import net.ripe.rpki.commons.crypto.cms.SigningInformationUtil;
import net.ripe.rpki.commons.crypto.util.BouncyCastleUtil;
import net.ripe.rpki.commons.crypto.x509cert.AbstractX509CertificateWrapperException;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateParser;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSignerInfoVerifierBuilder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.util.StoreException;
import org.joda.time.DateTime;

public abstract class RpkiSignedObjectParser {
    private static final int CMS_OBJECT_VERSION = 3;
    private static final int CMS_OBJECT_SIGNER_VERSION = 3;
    private byte[] encoded;
    private X509ResourceCertificate certificate;
    protected ASN1ObjectIdentifier contentType;
    private Optional<DateTime> signingTime;
    private ValidationResult validationResult;

    public final void parse(String location, byte[] encoded) {
        this.parse(ValidationResult.withLocation(location), encoded);
    }

    public void parse(ValidationResult result, byte[] encoded) {
        this.validationResult = result;
        this.encoded = encoded;
        this.parseCms();
    }

    protected byte[] getEncoded() {
        return this.encoded;
    }

    public ValidationResult getValidationResult() {
        return this.validationResult;
    }

    protected X509ResourceCertificate getCertificate() {
        return this.certificate;
    }

    protected X509ResourceCertificate getResourceCertificate() {
        return this.certificate;
    }

    protected ASN1ObjectIdentifier getContentType() {
        return this.contentType;
    }

    protected DateTime getSigningTime() {
        return this.signingTime.orElse(null);
    }

    public void decodeRawContent(InputStream content) throws IOException {
        try (ASN1InputStream asn1InputStream = new ASN1InputStream(content);){
            this.decodeAsn1Content((ASN1Encodable)asn1InputStream.readObject());
            this.validationResult.rejectIfFalse(asn1InputStream.readObject() == null, "cms.only.one.signed.object");
            this.validationResult.pass("cms.content.parsing");
        }
        catch (IOException e) {
            this.validationResult.error("cms.content.parsing");
        }
    }

    public void decodeAsn1Content(ASN1Encodable content) {
    }

    private void parseCms() {
        CMSSignedDataParser sp;
        try {
            sp = new CMSSignedDataParser(BouncyCastleUtil.DIGEST_CALCULATOR_PROVIDER, this.encoded);
            this.validationResult.pass("cms.signed.data.parsing");
        }
        catch (CMSException e) {
            this.validationResult.error("cms.signed.data.parsing");
            return;
        }
        this.parseContent(sp);
        this.parseCmsCertificate(sp);
        this.verifyContentType();
        this.verifyVersion(sp);
        this.verifyCrl(sp);
        if (this.certificate != null) {
            this.verifyCmsSigning(sp, this.certificate.getCertificate());
        }
    }

    protected void parseContent(CMSSignedDataParser sp) {
        CMSTypedStream signedContent = sp.getSignedContent();
        this.contentType = signedContent.getContentType();
        try (InputStream signedContentStream = signedContent.getContentStream();){
            this.decodeRawContent(signedContentStream);
            this.validationResult.pass("cms.decode.content");
        }
        catch (IOException e) {
            this.validationResult.error("cms.decode.content");
        }
    }

    private void verifyContentType() {
        try {
            CMSSignedData signedData = new CMSSignedData(this.encoded);
            this.validationResult.rejectIfFalse(CMSObjectIdentifiers.signedData.equals((ASN1Primitive)signedData.toASN1Structure().getContentType()), "cms.content.type");
        }
        catch (CMSException e) {
            this.validationResult.error("cms.signed.data.parsing");
        }
    }

    private void verifyVersion(CMSSignedDataParser sp) {
        this.validationResult.rejectIfFalse(sp.getVersion() == 3, "cms.signed.data.version");
    }

    private void verifyCrl(CMSSignedDataParser sp) {
        List<? extends X509CRL> crls = this.extractCrl(sp);
        if (!this.validationResult.rejectIfNull(crls, "cms.get.certs.and.crls")) {
            return;
        }
        this.validationResult.rejectIfFalse(crls.isEmpty(), "cms.no.crl");
    }

    private List<? extends X509CRL> extractCrl(CMSSignedDataParser sp) {
        try {
            return BouncyCastleUtil.extractCrls(sp);
        }
        catch (CRLException | CMSException | StoreException e) {
            return null;
        }
    }

    private void parseCmsCertificate(CMSSignedDataParser sp) {
        Collection<? extends Certificate> certificates = this.extractCertificate(sp);
        if (!this.validationResult.rejectIfNull(certificates, "cms.get.certs.and.crls")) {
            return;
        }
        if (!this.validationResult.rejectIfFalse(certificates.size() == 1, "cms.only.one.ee.cert")) {
            return;
        }
        if (!this.validationResult.rejectIfFalse(certificates.iterator().next() instanceof X509Certificate, "cms.cert.is.x509")) {
            return;
        }
        this.certificate = this.parseCertificate(certificates.iterator().next());
        if (this.validationResult.hasFailureForCurrentLocation()) {
            return;
        }
        this.validationResult.rejectIfFalse(this.certificate.isEe(), "cms.cert.is.ee.cert");
        this.validationResult.rejectIfNull(this.certificate.getSubjectKeyIdentifier(), "cms.cert.has.ski");
    }

    private X509ResourceCertificate parseCertificate(Certificate certificate) {
        try {
            X509Certificate x509certificate = (X509Certificate)certificate;
            X509ResourceCertificateParser parser = new X509ResourceCertificateParser();
            parser.parse(this.validationResult, x509certificate.getEncoded());
            return parser.isSuccess() ? parser.getCertificate() : null;
        }
        catch (CertificateEncodingException e) {
            throw new AbstractX509CertificateWrapperException("cannot parse already decoded X509 certificate: " + e, e);
        }
    }

    private Collection<? extends Certificate> extractCertificate(CMSSignedDataParser sp) {
        try {
            return BouncyCastleUtil.extractCertificates(sp);
        }
        catch (CertificateException | CMSException | StoreException e) {
            return null;
        }
    }

    private void verifyCmsSigning(CMSSignedDataParser sp, X509Certificate certificate) {
        SignerInformation signer = this.extractSingleCmsSigner(sp);
        if (signer == null) {
            return;
        }
        if (!this.verifySigner(signer, certificate)) {
            return;
        }
        SigningInformationUtil.SigningTimeResult st = SigningInformationUtil.extractSigningTime(this.validationResult, signer);
        if (!st.valid) {
            return;
        }
        this.signingTime = st.optionalSigningTime;
        this.verifySignature(certificate, signer);
    }

    private SignerInformation extractSingleCmsSigner(CMSSignedDataParser sp) {
        SignerInformationStore signerStore = this.getSignerStore(sp);
        if (!this.validationResult.rejectIfNull(signerStore, "cms.signature.signer.info")) {
            return null;
        }
        Collection signers = signerStore.getSigners();
        if (this.validationResult.rejectIfFalse(signers.size() == 1, "cms.signature.has.one.signer")) {
            return (SignerInformation)signers.iterator().next();
        }
        return null;
    }

    private SignerInformationStore getSignerStore(CMSSignedDataParser sp) {
        try {
            return sp.getSignerInfos();
        }
        catch (RuntimeException | CMSException e) {
            return null;
        }
    }

    private boolean isAllowedSignedAttribute(Attribute signedAttribute) {
        ASN1ObjectIdentifier attributeOID = signedAttribute.getAttrType();
        return CMSAttributes.binarySigningTime.equals((ASN1Primitive)attributeOID) || CMSAttributes.signingTime.equals((ASN1Primitive)attributeOID) || CMSAttributes.contentType.equals((ASN1Primitive)attributeOID) || CMSAttributes.messageDigest.equals((ASN1Primitive)attributeOID);
    }

    private boolean verifyOptionalSignedAttributes(SignerInformation signer) {
        ASN1EncodableVector signedAttributes = signer.getSignedAttributes().toASN1EncodableVector();
        HashSet<Attribute> seenAttributes = new HashSet<Attribute>();
        boolean allAttributesCorrect = true;
        for (int i = 0; i < signedAttributes.size(); ++i) {
            Attribute signedAttribute = (Attribute)signedAttributes.get(i);
            if (!this.isAllowedSignedAttribute(signedAttribute)) {
                allAttributesCorrect = false;
                break;
            }
            if (!seenAttributes.add(signedAttribute)) {
                allAttributesCorrect = false;
                break;
            }
            if (signedAttribute.getAttributeValues() != null && signedAttribute.getAttributeValues().length == 1) continue;
            allAttributesCorrect = false;
            break;
        }
        this.validationResult.rejectIfFalse(allAttributesCorrect, "cms.signed.attrs.correct");
        return allAttributesCorrect;
    }

    private boolean verifySigner(SignerInformation signer, X509Certificate certificate) {
        this.verifySignerVersion(signer);
        this.validationResult.rejectIfFalse(RpkiSignedObject.DIGEST_ALGORITHM_OID.equals(signer.getDigestAlgOID()), "cms.signer.info.digest.algorithm");
        this.validationResult.rejectIfFalse(RpkiSignedObject.ALLOWED_SIGNATURE_ALGORITHM_OIDS.contains(signer.getEncryptionAlgOID()), "cms.encryption.algorithm");
        if (!this.validationResult.rejectIfNull(signer.getSignedAttributes(), "cms.signed.attrs.present")) {
            return false;
        }
        this.validationResult.rejectIfNull(signer.getSignedAttributes().get(CMSAttributes.contentType), "cms.content.type.attr.present");
        this.validationResult.rejectIfNull(signer.getSignedAttributes().get(CMSAttributes.messageDigest), "cms.msg.digest.attr.present");
        this.verifyOptionalSignedAttributes(signer);
        this.verifyUnsignedAttributes(signer);
        SignerId signerId = signer.getSID();
        try {
            this.validationResult.rejectIfFalse(signerId.match((Object)new JcaX509CertificateHolder(certificate)), "cms.signer.id.match.cert");
        }
        catch (CertificateEncodingException e) {
            throw new AbstractX509CertificateWrapperException(e);
        }
        return true;
    }

    private void verifySignerVersion(SignerInformation signer) {
        this.validationResult.rejectIfFalse(signer.getVersion() == 3, "cms.signer.info.version");
    }

    private void verifySignature(X509Certificate certificate, SignerInformation signer) {
        String errorMessage = null;
        try {
            SignerInformationVerifier verifier = new JcaSignerInfoVerifierBuilder(BouncyCastleUtil.DIGEST_CALCULATOR_PROVIDER).build(certificate.getPublicKey());
            this.validationResult.rejectIfFalse(signer.verify(verifier), "cms.signature");
        }
        catch (CMSException | OperatorCreationException e) {
            errorMessage = String.valueOf(e.getMessage());
        }
        if (errorMessage != null) {
            this.validationResult.rejectIfFalse(false, "cms.signature", errorMessage);
        }
    }

    private void verifyUnsignedAttributes(SignerInformation signer) {
        this.validationResult.rejectIfFalse(signer.getUnsignedAttributes() == null, "cms.unsigned.attrs.omitted");
    }

    protected static BigInteger getRpkiObjectVersion(ASN1Sequence seq) {
        ASN1Primitive o;
        ASN1Primitive asn1Version = seq.getObjectAt(0).toASN1Primitive();
        BigInteger version = null;
        if (asn1Version instanceof ASN1Integer) {
            version = ((ASN1Integer)asn1Version).getValue();
        } else if (asn1Version instanceof DERTaggedObject && (o = ((DERTaggedObject)asn1Version).getObject()) instanceof ASN1Integer) {
            version = ((ASN1Integer)o).getValue();
        }
        return version;
    }
}

