/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.identity;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.ripe.rpki.commons.provisioning.x509.ProvisioningIdentityCertificate;

public final class PublisherRequest {
    public static final int VERSION = 1;
    private final Optional<String> tag;
    private final String publisherHandle;
    private final ProvisioningIdentityCertificate publisherBpkiTa;
    private final Optional<Referral> referral;

    public PublisherRequest(ProvisioningIdentityCertificate publisherBpkiTa) {
        this(Optional.empty(), UUID.randomUUID().toString(), publisherBpkiTa, Optional.empty());
    }

    public PublisherRequest(Optional<String> tag, String publisherHandle, ProvisioningIdentityCertificate publisherBpkiTa, Optional<Referral> referral) {
        this.tag = Objects.requireNonNull(tag, "tag must not be null");
        this.publisherHandle = Objects.requireNonNull(publisherHandle, "handle must not be null");
        this.publisherBpkiTa = Objects.requireNonNull(publisherBpkiTa, "identityCertificate must not be null");
        this.referral = Objects.requireNonNull(referral, "referral must not be null");
    }

    public int getVersion() {
        return 1;
    }

    public Optional<String> getTag() {
        return this.tag;
    }

    public String getPublisherHandle() {
        return this.publisherHandle;
    }

    public ProvisioningIdentityCertificate getPublisherBpkiTa() {
        return this.publisherBpkiTa;
    }

    public Optional<Referral> getReferral() {
        return this.referral;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PublisherRequest)) {
            return false;
        }
        PublisherRequest other = (PublisherRequest)o;
        Optional<String> this$tag = this.getTag();
        Optional<String> other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !((Object)this$tag).equals(other$tag)) {
            return false;
        }
        String this$publisherHandle = this.getPublisherHandle();
        String other$publisherHandle = other.getPublisherHandle();
        if (this$publisherHandle == null ? other$publisherHandle != null : !this$publisherHandle.equals(other$publisherHandle)) {
            return false;
        }
        ProvisioningIdentityCertificate this$publisherBpkiTa = this.getPublisherBpkiTa();
        ProvisioningIdentityCertificate other$publisherBpkiTa = other.getPublisherBpkiTa();
        if (this$publisherBpkiTa == null ? other$publisherBpkiTa != null : !((Object)this$publisherBpkiTa).equals(other$publisherBpkiTa)) {
            return false;
        }
        Optional<Referral> this$referral = this.getReferral();
        Optional<Referral> other$referral = other.getReferral();
        return !(this$referral == null ? other$referral != null : !((Object)this$referral).equals(other$referral));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<String> $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : ((Object)$tag).hashCode());
        String $publisherHandle = this.getPublisherHandle();
        result = result * 59 + ($publisherHandle == null ? 43 : $publisherHandle.hashCode());
        ProvisioningIdentityCertificate $publisherBpkiTa = this.getPublisherBpkiTa();
        result = result * 59 + ($publisherBpkiTa == null ? 43 : ((Object)$publisherBpkiTa).hashCode());
        Optional<Referral> $referral = this.getReferral();
        result = result * 59 + ($referral == null ? 43 : ((Object)$referral).hashCode());
        return result;
    }

    public String toString() {
        return "PublisherRequest(tag=" + this.getTag() + ", publisherHandle=" + this.getPublisherHandle() + ", publisherBpkiTa=" + this.getPublisherBpkiTa() + ", referral=" + this.getReferral() + ")";
    }

    public static final class Referral {
        private final String referrer;
        private final byte[] authorizationToken;

        public Referral(String referrer, byte[] authorizationToken) {
            this.referrer = referrer;
            this.authorizationToken = authorizationToken;
        }

        public String getReferrer() {
            return this.referrer;
        }

        public byte[] getAuthorizationToken() {
            return this.authorizationToken;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Referral)) {
                return false;
            }
            Referral other = (Referral)o;
            String this$referrer = this.getReferrer();
            String other$referrer = other.getReferrer();
            if (this$referrer == null ? other$referrer != null : !this$referrer.equals(other$referrer)) {
                return false;
            }
            return Arrays.equals(this.getAuthorizationToken(), other.getAuthorizationToken());
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $referrer = this.getReferrer();
            result = result * 59 + ($referrer == null ? 43 : $referrer.hashCode());
            result = result * 59 + Arrays.hashCode(this.getAuthorizationToken());
            return result;
        }

        public String toString() {
            return "PublisherRequest.Referral(referrer=" + this.getReferrer() + ", authorizationToken=" + Arrays.toString(this.getAuthorizationToken()) + ")";
        }
    }
}

