/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.util;

import java.io.IOException;
import java.security.PublicKey;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class EncodedPublicKey
implements PublicKey {
    private static final long serialVersionUID = 2L;
    private final ASN1Sequence sequence;

    public EncodedPublicKey(byte[] encoded) {
        this.sequence = ASN1Sequence.getInstance((Object)encoded);
        if (this.sequence.size() != 2) {
            throw new IllegalArgumentException("Bad sequence size: " + this.sequence.size());
        }
        AlgorithmIdentifier algId = AlgorithmIdentifier.getInstance((Object)this.sequence.getObjectAt(0));
        if (!algId.getAlgorithm().on(PKCSObjectIdentifiers.pkcs_1)) {
            throw new IllegalArgumentException("Not a PKCS#1 signature algorithm" + algId.getAlgorithm());
        }
    }

    @Override
    public byte[] getEncoded() {
        try {
            return this.sequence.getEncoded();
        }
        catch (IOException e) {
            throw new IllegalStateException("Lost access to loaded public key data", e);
        }
    }

    @Override
    public String getAlgorithm() {
        return "RSA";
    }

    @Override
    public String getFormat() {
        return "X.509";
    }
}

