/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms.aspa;

import com.google.common.collect.ImmutableSortedSet;
import java.security.PrivateKey;
import lombok.NonNull;
import net.ripe.ipresource.Asn;
import net.ripe.rpki.commons.crypto.cms.RpkiSignedObjectBuilder;
import net.ripe.rpki.commons.crypto.cms.aspa.AspaCms;
import net.ripe.rpki.commons.crypto.cms.aspa.AspaCmsParser;
import net.ripe.rpki.commons.crypto.cms.aspa.ProviderAS;
import net.ripe.rpki.commons.crypto.util.Asn1Util;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.apache.commons.lang3.Validate;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERSequence;

public class AspaCmsBuilder
extends RpkiSignedObjectBuilder {
    private X509ResourceCertificate certificate;
    private String signatureProvider;
    private Asn customerAsn;
    private ImmutableSortedSet<ProviderAS> providerASSet;

    public AspaCmsBuilder withCertificate(X509ResourceCertificate certificate) {
        this.certificate = certificate;
        return this;
    }

    public AspaCmsBuilder withSignatureProvider(String signatureProvider) {
        this.signatureProvider = signatureProvider;
        return this;
    }

    public AspaCmsBuilder withCustomerAsn(@NonNull Asn customerAsn) {
        if (customerAsn == null) {
            throw new NullPointerException("customerAsn is marked non-null but is null");
        }
        this.customerAsn = customerAsn;
        return this;
    }

    public AspaCmsBuilder withProviderASSet(Iterable<? extends ProviderAS> providerASSet) {
        this.providerASSet = ImmutableSortedSet.naturalOrder().addAll(providerASSet).build();
        return this;
    }

    public AspaCms build(PrivateKey privateKey) {
        String location = "unknown.asa";
        AspaCmsParser parser = new AspaCmsParser();
        parser.parse(ValidationResult.withLocation(location), this.getEncoded(privateKey));
        return parser.getAspa();
    }

    public byte[] getEncoded(PrivateKey privateKey) {
        return this.generateCms(this.certificate.getCertificate(), privateKey, this.signatureProvider, AspaCms.CONTENT_TYPE, this.encodeAspa());
    }

    private byte[] encodeAspa() {
        Validate.notNull((Object)this.customerAsn, (String)"Customer AS ID must not be null", (Object[])new Object[0]);
        Validate.notEmpty(this.providerASSet, (String)"ProviderASSet must not be empty", (Object[])new Object[0]);
        ASN1Encodable[] encodables = new ASN1Encodable[]{new ASN1Integer(this.customerAsn.getValue()), new DERSequence((ASN1Encodable[])this.providerASSet.stream().map(as -> {
            if (as.getAfiLimit().isPresent()) {
                return new DERSequence(new ASN1Encodable[]{new ASN1Integer(as.getProviderAsn().getValue()), as.getAfiLimit().get().toDer()});
            }
            return new DERSequence(new ASN1Encodable[]{new ASN1Integer(as.getProviderAsn().getValue())});
        }).toArray(ASN1Encodable[]::new))};
        return Asn1Util.encode((ASN1Encodable)new DERSequence(encodables));
    }
}

