/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.xml;

import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import net.ripe.rpki.commons.xml.AliasedNetRipeTypePermission;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AliasedNetRipeTypePermissionTest {
    private XStream xStream;
    private AliasedNetRipeTypePermission permission;

    @Before
    public void initialize() {
        this.xStream = new XStream();
        this.permission = new AliasedNetRipeTypePermission(this.xStream);
    }

    @Test
    public void shouldAcceptAliasedTypes() {
        Assert.assertFalse((boolean)this.permission.allows(SerializeMe.class));
        this.xStream.alias("serialize-me", SerializeMe.class);
        Assert.assertTrue((boolean)this.permission.allows(SerializeMe.class));
    }

    @Test
    public void shouldAcceptAliasedPackageMembers() {
        Assert.assertFalse((boolean)this.permission.allows(SerializeMe.class));
        this.xStream.aliasPackage("rpki-commons", "net.ripe.rpki.commons");
        Assert.assertTrue((boolean)this.permission.allows(SerializeMe.class));
    }

    @Test
    public void shoudldRejectNonRipeTypes() {
        this.xStream.alias("non-ripe-type", ArrayList.class);
        Assert.assertFalse((boolean)this.permission.allows(ArrayList.class));
    }

    private static class SerializeMe {
        private SerializeMe() {
        }
    }
}

