/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.util;

import java.util.Arrays;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.UnknownCertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.cms.aspa.AspaCms;
import net.ripe.rpki.commons.crypto.cms.aspa.AspaCmsTest;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCms;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCmsTest;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCms;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCmsTest;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.crl.X509CrlTest;
import net.ripe.rpki.commons.crypto.util.CertificateRepositoryObjectFactory;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateTest;
import net.ripe.rpki.commons.validation.ValidationCheck;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.ValidationStatus;
import org.junit.Assert;
import org.junit.Test;

public class CertificateRepositoryObjectFactoryTest {
    @Test
    public void unknownFileExtensionsShouldProduceAnError() {
        byte[] encoded = new byte[]{0, 1};
        String unknownFileExtension = "file.unknown";
        ValidationResult validationResult = ValidationResult.withLocation((String)unknownFileExtension);
        CertificateRepositoryObject object = CertificateRepositoryObjectFactory.createCertificateRepositoryObject((byte[])encoded, (ValidationResult)validationResult);
        Assert.assertTrue((boolean)(object instanceof UnknownCertificateRepositoryObject));
        Assert.assertEquals((Object)encoded, (Object)object.getEncoded());
        Assert.assertFalse((boolean)validationResult.hasWarnings());
        Assert.assertTrue((boolean)validationResult.hasFailures());
        Assert.assertEquals((long)1L, (long)validationResult.getAllValidationChecksForCurrentLocation().size());
        ValidationCheck check = validationResult.getResultForCurrentLocation("known.object.type");
        Assert.assertEquals((Object)ValidationStatus.ERROR, (Object)check.getStatus());
        Assert.assertTrue((boolean)Arrays.asList(check.getParams()).contains(unknownFileExtension));
    }

    @Test
    public void shouldParseResourceCertificate() {
        ValidationResult validationResult = ValidationResult.withLocation((ValidationLocation)new ValidationLocation("certificate.cer"));
        X509ResourceCertificate cert = X509ResourceCertificateTest.createSelfSignedCaResourceCertificate();
        CertificateRepositoryObject object = CertificateRepositoryObjectFactory.createCertificateRepositoryObject((byte[])cert.getEncoded(), (ValidationResult)validationResult);
        Assert.assertFalse((String)("no validation failures " + validationResult.getFailuresForCurrentLocation()), (boolean)validationResult.hasFailureForCurrentLocation());
        Assert.assertTrue((boolean)(object instanceof X509ResourceCertificate));
        Assert.assertEquals((Object)cert, (Object)object);
        Assert.assertEquals((long)32L, (long)validationResult.getAllValidationChecksForCurrentLocation().size());
        Assert.assertTrue((boolean)validationResult.hasNoFailuresOrWarnings());
        Assert.assertTrue((boolean)validationResult.getResultForCurrentLocation("known.object.type").isOk());
        Assert.assertTrue((boolean)validationResult.getResultForCurrentLocation("cert.parsed").isOk());
    }

    @Test
    public void shouldParseMalformedResourceCertificate() {
        byte[] encoded = new byte[]{0, 1};
        ValidationResult validationResult = ValidationResult.withLocation((ValidationLocation)new ValidationLocation("certificate.cer"));
        CertificateRepositoryObject object = CertificateRepositoryObjectFactory.createCertificateRepositoryObject((byte[])encoded, (ValidationResult)validationResult);
        Assert.assertNull((Object)object);
        Assert.assertEquals((long)2L, (long)validationResult.getAllValidationChecksForCurrentLocation().size());
        Assert.assertTrue((boolean)validationResult.getResultForCurrentLocation("known.object.type").isOk());
        Assert.assertFalse((boolean)validationResult.getResultForCurrentLocation("cert.parsed").isOk());
    }

    @Test
    public void shouldParseRoaCms() {
        ValidationResult validationResult = ValidationResult.withLocation((ValidationLocation)new ValidationLocation("roa.roa"));
        RoaCms roaCms = RoaCmsTest.getRoaCms();
        CertificateRepositoryObject object = CertificateRepositoryObjectFactory.createCertificateRepositoryObject((byte[])roaCms.getEncoded(), (ValidationResult)validationResult);
        Assert.assertTrue((boolean)(object instanceof RoaCms));
        Assert.assertEquals((Object)roaCms, (Object)object);
        Assert.assertEquals((long)64L, (long)validationResult.getAllValidationChecksForCurrentLocation().size());
        Assert.assertFalse((boolean)validationResult.hasFailures());
        Assert.assertTrue((boolean)validationResult.getResultForCurrentLocation("known.object.type").isOk());
        Assert.assertEquals((Object)ValidationStatus.WARNING, (Object)validationResult.getResultForCurrentLocation("cert.crldp.omitted").getStatus());
    }

    @Test
    public void shouldParseMalformedRoaCms() {
        byte[] encoded = new byte[]{0, 1};
        ValidationResult validationResult = ValidationResult.withLocation((ValidationLocation)new ValidationLocation("roa.roa"));
        CertificateRepositoryObject object = CertificateRepositoryObjectFactory.createCertificateRepositoryObject((byte[])encoded, (ValidationResult)validationResult);
        Assert.assertNull((Object)object);
        Assert.assertEquals((long)3L, (long)validationResult.getAllValidationChecksForCurrentLocation().size());
        Assert.assertTrue((boolean)validationResult.getResultForCurrentLocation("known.object.type").isOk());
        Assert.assertFalse((boolean)validationResult.getResultForCurrentLocation("cms.signed.data.parsing").isOk());
        Assert.assertFalse((boolean)validationResult.getResultForCurrentLocation("roa.content.type").isOk());
    }

    @Test
    public void shouldParseManifestCms() {
        ValidationResult validationResult = ValidationResult.withLocation((ValidationLocation)new ValidationLocation("manifest.mft"));
        ManifestCms manifestCms = ManifestCmsTest.getRootManifestCms();
        CertificateRepositoryObject object = CertificateRepositoryObjectFactory.createCertificateRepositoryObject((byte[])manifestCms.getEncoded(), (ValidationResult)validationResult);
        Assert.assertTrue((boolean)(object instanceof ManifestCms));
        Assert.assertEquals((Object)manifestCms, (Object)object);
        Assert.assertEquals((long)67L, (long)validationResult.getAllValidationChecksForCurrentLocation().size());
        Assert.assertTrue((String)("" + validationResult.getAllValidationChecksForCurrentLocation()), (boolean)validationResult.hasNoFailuresOrWarnings());
        Assert.assertTrue((boolean)validationResult.getResultForCurrentLocation("known.object.type").isOk());
    }

    @Test
    public void shouldParseMalformedManifestCms() {
        byte[] encoded = new byte[]{0, 1};
        ValidationResult validationResult = ValidationResult.withLocation((ValidationLocation)new ValidationLocation("manifest.mft"));
        CertificateRepositoryObject object = CertificateRepositoryObjectFactory.createCertificateRepositoryObject((byte[])encoded, (ValidationResult)validationResult);
        Assert.assertNull((Object)object);
        Assert.assertEquals((long)2L, (long)validationResult.getAllValidationChecksForCurrentLocation().size());
        Assert.assertTrue((boolean)validationResult.getResultForCurrentLocation("known.object.type").isOk());
        Assert.assertFalse((boolean)validationResult.getResultForCurrentLocation("cms.signed.data.parsing").isOk());
    }

    @Test
    public void shouldParseCrl() {
        ValidationResult validationResult = ValidationResult.withLocation((ValidationLocation)new ValidationLocation("crl.crl"));
        X509Crl crl = X509CrlTest.createCrl();
        CertificateRepositoryObject object = CertificateRepositoryObjectFactory.createCertificateRepositoryObject((byte[])crl.getEncoded(), (ValidationResult)validationResult);
        Assert.assertTrue((boolean)(object instanceof X509Crl));
        Assert.assertEquals((Object)crl, (Object)object);
        Assert.assertEquals((long)2L, (long)validationResult.getAllValidationChecksForCurrentLocation().size());
        Assert.assertTrue((boolean)validationResult.hasNoFailuresOrWarnings());
        Assert.assertTrue((boolean)validationResult.getResultForCurrentLocation("known.object.type").isOk());
        Assert.assertTrue((boolean)validationResult.getResultForCurrentLocation("crl.parsed").isOk());
    }

    @Test
    public void shouldParseMalformedCrl() {
        byte[] encoded = new byte[]{0, 1};
        ValidationResult validationResult = ValidationResult.withLocation((ValidationLocation)new ValidationLocation("crl.crl"));
        CertificateRepositoryObject object = CertificateRepositoryObjectFactory.createCertificateRepositoryObject((byte[])encoded, (ValidationResult)validationResult);
        Assert.assertNull((Object)object);
        Assert.assertEquals((long)2L, (long)validationResult.getAllValidationChecksForCurrentLocation().size());
        Assert.assertTrue((boolean)validationResult.getResultForCurrentLocation("known.object.type").isOk());
        Assert.assertFalse((boolean)validationResult.getResultForCurrentLocation("crl.parsed").isOk());
    }

    @Test
    public void shouldParseMalformedGhostbustersRecord() {
        byte[] encoded = new byte[]{0, 1};
        ValidationResult validationResult = ValidationResult.withLocation((ValidationLocation)new ValidationLocation("ghostbusters.gbr"));
        CertificateRepositoryObject object = CertificateRepositoryObjectFactory.createCertificateRepositoryObject((byte[])encoded, (ValidationResult)validationResult);
        Assert.assertNull((Object)object);
        Assert.assertEquals((long)3L, (long)validationResult.getAllValidationChecksForCurrentLocation().size());
        Assert.assertTrue((boolean)validationResult.getResultForCurrentLocation("known.object.type").isOk());
    }

    @Test
    public void shouldParseAspa() {
        ValidationResult validationResult = ValidationResult.withLocation((ValidationLocation)new ValidationLocation("aspa.asa"));
        AspaCms aspa = AspaCmsTest.createAspa();
        CertificateRepositoryObject object = CertificateRepositoryObjectFactory.createCertificateRepositoryObject((byte[])aspa.getEncoded(), (ValidationResult)validationResult);
        Assert.assertTrue((boolean)(object instanceof AspaCms));
        Assert.assertEquals((Object)aspa, (Object)object);
        Assert.assertEquals((String)("" + validationResult.getAllValidationChecksForCurrentLocation()), (long)61L, (long)validationResult.getAllValidationChecksForCurrentLocation().size());
        Assert.assertTrue((String)("" + validationResult.getAllValidationChecksForCurrentLocation()), (boolean)validationResult.hasNoFailuresOrWarnings());
        Assert.assertTrue((boolean)validationResult.getResultForCurrentLocation("known.object.type").isOk());
        Assert.assertTrue((boolean)validationResult.getResultForCurrentLocation("aspa.customer.asn.certified").isOk());
    }

    @Test
    public void shouldParseMalformedAspa() {
        byte[] encoded = new byte[]{0, 1};
        ValidationResult validationResult = ValidationResult.withLocation((ValidationLocation)new ValidationLocation("aspa.asa"));
        CertificateRepositoryObject object = CertificateRepositoryObjectFactory.createCertificateRepositoryObject((byte[])encoded, (ValidationResult)validationResult);
        Assert.assertNull((Object)object);
        Assert.assertEquals((String)("" + validationResult.getAllValidationChecksForCurrentLocation()), (long)4L, (long)validationResult.getAllValidationChecksForCurrentLocation().size());
        Assert.assertFalse((String)("" + validationResult.getAllValidationChecksForCurrentLocation()), (boolean)validationResult.hasNoFailuresOrWarnings());
        Assert.assertTrue((boolean)validationResult.getResultForCurrentLocation("known.object.type").isOk());
    }
}

