/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.validation.objectvalidators;

import java.security.InvalidKeyException;
import java.security.SignatureException;
import java.util.Arrays;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.x509cert.AbstractX509CertificateWrapper;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationOptions;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public abstract class X509CertificateParentChildValidator<T extends AbstractX509CertificateWrapper> {
    private static final int DIG_SIGN_INDEX = 0;
    private static final int KEYCERTSIGN_INDEX = 5;
    private static final int CRLSIGN_INDEX = 6;
    private T parent;
    protected T child;
    private X509Crl crl;
    protected final ValidationOptions options;
    protected final ValidationResult result;

    public X509CertificateParentChildValidator(ValidationOptions options, ValidationResult result, T parent, X509Crl crl) {
        this.options = options;
        this.result = result;
        this.parent = parent;
        this.crl = crl;
    }

    public void validate(String location, T certificate) {
        this.child = certificate;
        this.result.setLocation(new ValidationLocation(location));
        this.verifySignature();
        this.verifyValidity();
        this.verifyCrl();
        this.verifyIssuer();
        this.verifyKeyUsage();
        this.verifyAuthorityKeyIdentifier();
    }

    public ValidationResult getValidationResult() {
        return this.result;
    }

    protected T getChild() {
        return this.child;
    }

    private void verifySignature() {
        this.result.rejectIfFalse(((AbstractX509CertificateWrapper)this.parent).isCa(), "cert.issuer.is.ca", new String[0]);
        boolean errorOccurred = false;
        try {
            ((AbstractX509CertificateWrapper)this.child).verify(((AbstractX509CertificateWrapper)this.parent).getPublicKey());
        }
        catch (InvalidKeyException | SignatureException e) {
            errorOccurred = true;
        }
        this.result.rejectIfTrue(errorOccurred, "cert.signature", new String[0]);
    }

    private void verifyCrl() {
        if (this.crl == null) {
            this.result.rejectIfFalse(((AbstractX509CertificateWrapper)this.child).isRoot(), "crl.required", new String[0]);
            return;
        }
        boolean errorOccurred = false;
        try {
            this.crl.verify(((AbstractX509CertificateWrapper)this.parent).getPublicKey());
        }
        catch (SignatureException e) {
            errorOccurred = true;
        }
        this.result.rejectIfTrue(errorOccurred, "cert.crl.signature", new String[0]);
        this.result.rejectIfTrue(this.crl.isRevoked(((AbstractX509CertificateWrapper)this.child).getCertificate()), "cert.not.revoked", new String[0]);
    }

    protected void verifyValidity() {
        DateTime now = new DateTime();
        this.result.rejectIfTrue(now.isBefore((ReadableInstant)((AbstractX509CertificateWrapper)this.child).getValidityPeriod().getNotValidBefore()), "cert.not.valid.before", ((AbstractX509CertificateWrapper)this.child).getValidityPeriod().getNotValidBefore().toString());
        this.result.rejectIfTrue(now.isAfter((ReadableInstant)((AbstractX509CertificateWrapper)this.child).getValidityPeriod().getNotValidAfter()), "cert.not.valid.after", ((AbstractX509CertificateWrapper)this.child).getValidityPeriod().getNotValidAfter().toString());
    }

    private void verifyIssuer() {
        this.result.rejectIfFalse(((AbstractX509CertificateWrapper)this.parent).getSubject().equals(((AbstractX509CertificateWrapper)this.child).getIssuer()), "cert.issuer.eq.prev.subject", new String[0]);
    }

    protected void verifyKeyUsage() {
        boolean[] keyUsage = ((AbstractX509CertificateWrapper)this.child).getCertificate().getKeyUsage();
        if (!this.result.warnIfNull(keyUsage, "cert.key.usage.extension.present", new String[0])) {
            return;
        }
        if (((AbstractX509CertificateWrapper)this.child).isCa()) {
            this.result.warnIfFalse(keyUsage[5], "cert.key.cert.sign", new String[0]);
            this.result.warnIfFalse(keyUsage[6], "cert.crl.sign", new String[0]);
        } else {
            this.result.warnIfFalse(keyUsage[0], "cert.dig.sign", new String[0]);
        }
    }

    private void verifyAuthorityKeyIdentifier() {
        if (((AbstractX509CertificateWrapper)this.child).isRoot()) {
            return;
        }
        byte[] ski = ((AbstractX509CertificateWrapper)this.parent).getSubjectKeyIdentifier();
        byte[] aki = ((AbstractX509CertificateWrapper)this.child).getAuthorityKeyIdentifier();
        if (!this.result.rejectIfNull(ski, "cert.ski.present", new String[0]) || !this.result.rejectIfNull(aki, "cert.aki.present", new String[0])) {
            return;
        }
        this.result.rejectIfFalse(Arrays.equals(ski, aki), "cert.aki.eq.prev.ski", new String[0]);
    }
}

