/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms.ghostbuster;

import com.google.common.base.Charsets;
import java.security.PrivateKey;
import net.ripe.rpki.commons.crypto.cms.RpkiSignedObjectBuilder;
import net.ripe.rpki.commons.crypto.cms.ghostbuster.GhostbustersCms;
import net.ripe.rpki.commons.crypto.cms.ghostbuster.GhostbustersCmsParser;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.validation.ValidationResult;

public class GhostbustersCmsBuilder
extends RpkiSignedObjectBuilder {
    private X509ResourceCertificate certificate;
    private String vCardPayload;
    private String signatureProvider;

    public GhostbustersCmsBuilder withCertificate(X509ResourceCertificate certificate) {
        this.certificate = certificate;
        return this;
    }

    public GhostbustersCmsBuilder withVCardPayload(String vCardPayload) {
        this.vCardPayload = vCardPayload;
        return this;
    }

    public GhostbustersCmsBuilder withSignatureProvider(String signatureProvider) {
        this.signatureProvider = signatureProvider;
        return this;
    }

    public GhostbustersCms build(PrivateKey privateKey) {
        String location = "unknown.gbr";
        GhostbustersCmsParser parser = new GhostbustersCmsParser();
        parser.parse(ValidationResult.withLocation(location), this.getEncoded(privateKey));
        return parser.getGhostbustersCms();
    }

    public byte[] getEncoded(PrivateKey privateKey) {
        return this.generateCms(this.certificate.getCertificate(), privateKey, this.signatureProvider, GhostbustersCms.CONTENT_TYPE, this.vCardPayload.getBytes(Charsets.UTF_8));
    }
}

