/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.validation.objectvalidators;

import net.ripe.ipresource.IpResourceSet;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.validation.ValidationOptions;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import net.ripe.rpki.commons.validation.objectvalidators.X509CertificateParentChildValidator;
import net.ripe.rpki.commons.validation.objectvalidators.X509ResourceCertificateValidator;

public class X509ResourceCertificateParentChildLooseValidator
extends X509CertificateParentChildValidator<X509ResourceCertificate>
implements X509ResourceCertificateValidator {
    private final CertificateRepositoryObjectValidationContext context;

    public X509ResourceCertificateParentChildLooseValidator(ValidationOptions options, ValidationResult result, X509Crl crl, CertificateRepositoryObjectValidationContext context) {
        super(options, result, context.getCertificate(), crl);
        this.context = context;
    }

    @Override
    public void validate(String location, X509ResourceCertificate certificate) {
        super.validate(location, certificate);
        this.verifyResources();
    }

    private void verifyResources() {
        ValidationResult result = this.getValidationResult();
        X509ResourceCertificate child = (X509ResourceCertificate)this.getChild();
        IpResourceSet resources = this.context.getResources();
        IpResourceSet childResourceSet = child.deriveResources(resources);
        if (child.isRoot()) {
            result.rejectIfTrue(child.isResourceSetInherited(), "cert.root.resource.uses.inherit");
        } else if (!resources.contains(childResourceSet)) {
            IpResourceSet overclaiming = new IpResourceSet(childResourceSet);
            overclaiming.removeAll(resources);
            this.context.addOverclaiming(overclaiming);
            result.warnIfFalse(overclaiming.isEmpty(), "cert.resource.range.is.valid", overclaiming.toString());
        }
    }
}

