/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.util.encoders.Base64Encoder;
import org.bouncycastle.util.encoders.HexEncoder;

public final class KeyPairUtil {
    private KeyPairUtil() {
    }

    public static String getEncodedKeyIdentifier(PublicKey key) {
        String encoded = KeyPairUtil.base64UrlEncode(KeyPairUtil.getKeyIdentifier(key));
        return StringUtils.stripEnd((String)encoded, (String)"=");
    }

    public static String getAsciiHexEncodedPublicKeyHash(PublicKey publicKey) {
        return KeyPairUtil.hexEncodeHashData(KeyPairUtil.getKeyIdentifier(publicKey));
    }

    static String hexEncodeHashData(byte[] keyHashData) {
        HexEncoder hexEncoder = new HexEncoder();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            hexEncoder.encode(keyHashData, 0, keyHashData.length, (OutputStream)out);
            out.flush();
            return out.toString();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Exception hex encoding data", e);
        }
    }

    public static byte[] getKeyIdentifier(PublicKey key) {
        try {
            return new JcaX509ExtensionUtils().createSubjectKeyIdentifier(key).getKeyIdentifier();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Could not get SubjectKeyIdentifierStructure from key", e);
        }
    }

    public static String base64UrlEncode(byte[] data) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            new FileSystemSafeBase64UrlEncoder().encode(data, 0, data.length, out);
            out.flush();
            return out.toString();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Exception when base64url encoding data", e);
        }
    }

    public static class FileSystemSafeBase64UrlEncoder
    extends Base64Encoder {
        public FileSystemSafeBase64UrlEncoder() {
            this.encodingTable[this.encodingTable.length - 2] = 45;
            this.encodingTable[this.encodingTable.length - 1] = 95;
            this.initialiseDecodingTable();
        }
    }
}

