/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.validation;

import java.math.BigInteger;
import java.net.URI;
import java.security.KeyPair;
import java.security.cert.CRLException;
import java.util.EnumSet;
import javax.security.auth.x500.X500Principal;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.ipresource.IpResourceType;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObjectFile;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.crl.X509CrlBuilder;
import net.ripe.rpki.commons.crypto.util.PregeneratedKeyPairFactory;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateInformationAccessDescriptor;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateBuilder;
import net.ripe.rpki.commons.util.UTC;
import net.ripe.rpki.commons.validation.ValidationCheck;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.ValidationStatus;
import net.ripe.rpki.commons.validation.objectvalidators.ResourceCertificateLocator;
import net.ripe.rpki.commons.validation.objectvalidators.X509ResourceCertificateBottomUpValidator;
import org.apache.commons.lang3.Validate;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class X509ResourceCertificateBottomUpValidatorTest {
    private static final X500Principal ROOT_CERTIFICATE_NAME = new X500Principal("CN=For Testing Only - RIPE NCC - NL");
    private static final IpResourceSet ROOT_RESOURCE_SET = IpResourceSet.parse((String)"10.0.0.0/8, 192.168.0.0/16, ffce::/16, AS21212");
    private static final BigInteger ROOT_SERIAL_NUMBER = BigInteger.valueOf(900L);
    private static final ValidityPeriod VALIDITY_PERIOD = new ValidityPeriod((ReadableInstant)UTC.dateTime().minusMinutes(1), (ReadableInstant)UTC.dateTime().plusYears(1));
    private static final X500Principal FIRST_CHILD_CERTIFICATE_NAME = new X500Principal("CN=For Testing Only - First Child - NL");
    private static final BigInteger FIRST_CHILD_SERIAL_NUMBER = ROOT_SERIAL_NUMBER.add(BigInteger.valueOf(1L));
    private static final X500Principal SECOND_CHILD_CERTIFICATE_NAME = new X500Principal("CN=For Testing Only - Second Child - NL");
    private static final BigInteger SECOND_CHILD_SERIAL_NUMBER = FIRST_CHILD_SERIAL_NUMBER.add(BigInteger.valueOf(1L));
    private static final IpResourceSet CHILD_RESOURCE_SET = IpResourceSet.parse((String)"10.0.0.0/8, 192.168.0.0/17, ffce::/16, AS21212");
    private static final IpResourceSet INVALID_CHILD_RESOURCE_SET = IpResourceSet.parse((String)"10.0.0.0/8, 192.168.0.0/15, ffce::/16, AS21212");
    private static final ValidityPeriod EXPIRED_VALIDITY_PERIOD = new ValidityPeriod((ReadableInstant)UTC.dateTime().minusMonths(2), (ReadableInstant)UTC.dateTime().minusMonths(1));
    private static final KeyPair ROOT_KEY_PAIR = PregeneratedKeyPairFactory.getInstance().generate();
    private static final KeyPair FIRST_CHILD_KEY_PAIR = PregeneratedKeyPairFactory.getInstance().generate();
    private static final KeyPair SECOND_CHILD_KEY_PAIR = PregeneratedKeyPairFactory.getInstance().generate();
    private static final ValidationLocation CHILD_VALIDATION_LOCATION = new ValidationLocation("child");
    private static final ValidationLocation GRAND_CHILD_VALIDATION_LOCATION = new ValidationLocation("grandchild");
    private X509ResourceCertificate root;
    private X509ResourceCertificate child;
    private X509ResourceCertificate grandchild;
    private X509Crl rootCrl;
    private X509Crl childCrl;

    @Before
    public void setUp() {
        this.root = this.getRootResourceCertificate();
        this.child = this.createChildBuilder().build();
        this.grandchild = null;
        this.rootCrl = this.getRootCRL().build(ROOT_KEY_PAIR.getPrivate());
        this.childCrl = this.getChildCRL().build(FIRST_CHILD_KEY_PAIR.getPrivate());
    }

    @Test
    public void testShouldBeValidRootCertificate() {
        X509ResourceCertificateBottomUpValidator validator = new X509ResourceCertificateBottomUpValidator((ResourceCertificateLocator)new ResourceCertificateLocatorImpl(), new X509ResourceCertificate[0]);
        validator.validate("root", this.root);
        Assert.assertFalse((boolean)validator.getValidationResult().hasFailures());
    }

    @Test
    public void testShouldBeValidChildCertificates() throws CRLException {
        this.child = this.createChildBuilder().build();
        this.grandchild = this.createSecondChildBuilder().build();
        X509ResourceCertificateBottomUpValidator validator = new X509ResourceCertificateBottomUpValidator((ResourceCertificateLocator)new ResourceCertificateLocatorImpl(), new X509ResourceCertificate[]{this.root});
        validator.validate("grandchild", this.grandchild);
        Assert.assertFalse((boolean)validator.getValidationResult().hasFailures());
    }

    @Test
    public void testShouldFailOnInvalidResorceSet() {
        this.child = this.createChildBuilder().withInheritedResourceTypes(EnumSet.noneOf(IpResourceType.class)).withResources(INVALID_CHILD_RESOURCE_SET).build();
        X509ResourceCertificateBottomUpValidator validator = new X509ResourceCertificateBottomUpValidator((ResourceCertificateLocator)new ResourceCertificateLocatorImpl(), new X509ResourceCertificate[0]);
        validator.validate("child", this.child);
        Assert.assertTrue((boolean)validator.getValidationResult().hasFailures());
        Assert.assertTrue((boolean)validator.getValidationResult().hasFailureForLocation(CHILD_VALIDATION_LOCATION));
        Assert.assertTrue((boolean)"cert.resource.range.is.valid".equals(((ValidationCheck)validator.getValidationResult().getFailures(CHILD_VALIDATION_LOCATION).get(0)).getKey()));
    }

    @Test
    public void testShouldFailOnInvalidResourceSetAfterInheritance() {
        this.child = this.createChildBuilder().build();
        this.grandchild = this.createSecondChildBuilder().withResources(INVALID_CHILD_RESOURCE_SET).build();
        X509ResourceCertificateBottomUpValidator validator = new X509ResourceCertificateBottomUpValidator((ResourceCertificateLocator)new ResourceCertificateLocatorImpl(), new X509ResourceCertificate[0]);
        validator.validate("grandchild", this.grandchild);
        Assert.assertTrue((boolean)validator.getValidationResult().hasFailures());
        System.out.println(validator.getValidationResult().getFailuresForAllLocations());
        Assert.assertTrue((boolean)validator.getValidationResult().hasFailureForLocation(GRAND_CHILD_VALIDATION_LOCATION));
        Assert.assertTrue((boolean)"cert.resource.range.is.valid".equals(((ValidationCheck)validator.getValidationResult().getFailures(GRAND_CHILD_VALIDATION_LOCATION).get(0)).getKey()));
    }

    @Test
    public void testShouldFailOnInvalidSignature() {
        this.child = this.createChildBuilder().withSigningKeyPair(FIRST_CHILD_KEY_PAIR).build();
        X509ResourceCertificateBottomUpValidator validator = new X509ResourceCertificateBottomUpValidator((ResourceCertificateLocator)new ResourceCertificateLocatorImpl(), new X509ResourceCertificate[0]);
        validator.validate("child", this.child);
        Assert.assertTrue((boolean)validator.getValidationResult().hasFailures());
        Assert.assertTrue((boolean)validator.getValidationResult().hasFailureForLocation(CHILD_VALIDATION_LOCATION));
        Assert.assertTrue((boolean)"cert.signature".equals(((ValidationCheck)validator.getValidationResult().getFailures(CHILD_VALIDATION_LOCATION).get(0)).getKey()));
    }

    @Test
    public void testShouldFailOnExpiredValidityPeriod() {
        this.child = this.createChildBuilder().withValidityPeriod(EXPIRED_VALIDITY_PERIOD).build();
        X509ResourceCertificateBottomUpValidator validator = new X509ResourceCertificateBottomUpValidator((ResourceCertificateLocator)new ResourceCertificateLocatorImpl(), new X509ResourceCertificate[0]);
        validator.validate("child", this.child);
        Assert.assertTrue((boolean)validator.getValidationResult().hasFailures());
        Assert.assertTrue((boolean)validator.getValidationResult().hasFailureForLocation(CHILD_VALIDATION_LOCATION));
        Assert.assertTrue((boolean)"cert.not.valid.after".equals(((ValidationCheck)validator.getValidationResult().getFailures(CHILD_VALIDATION_LOCATION).get(0)).getKey()));
    }

    @Test
    public void testShouldFailOnInvalidIssuer() {
        this.child = this.createChildBuilder().withIssuerDN(SECOND_CHILD_CERTIFICATE_NAME).build();
        X509ResourceCertificateBottomUpValidator validator = new X509ResourceCertificateBottomUpValidator((ResourceCertificateLocator)new ResourceCertificateLocatorImpl(), new X509ResourceCertificate[0]);
        validator.validate("child", this.child);
        System.out.println(validator.getValidationResult());
        Assert.assertTrue((boolean)validator.getValidationResult().hasFailures());
        Assert.assertTrue((boolean)validator.getValidationResult().hasFailureForLocation(CHILD_VALIDATION_LOCATION));
        Assert.assertTrue((boolean)"cert.issuer.eq.prev.subject".equals(((ValidationCheck)validator.getValidationResult().getFailures(CHILD_VALIDATION_LOCATION).get(0)).getKey()));
    }

    @Test
    public void testShouldWarnOnMissingKeyUsage() {
        this.child = this.createChildBuilder().withKeyUsage(0).build();
        X509ResourceCertificateBottomUpValidator validator = new X509ResourceCertificateBottomUpValidator((ResourceCertificateLocator)new ResourceCertificateLocatorImpl(), new X509ResourceCertificate[0]);
        validator.validate("child", this.child);
        Assert.assertFalse((boolean)validator.getValidationResult().hasFailures());
        Assert.assertEquals((Object)validator.getValidationResult().getResult(CHILD_VALIDATION_LOCATION, "cert.key.usage.extension.present"), (Object)new ValidationCheck(ValidationStatus.WARNING, "cert.key.usage.extension.present", new String[0]));
    }

    @Test
    public void testShouldWarnOnInvalidKeyUsage() {
        this.child = this.createChildBuilder().withKeyUsage(128).build();
        X509ResourceCertificateBottomUpValidator validator = new X509ResourceCertificateBottomUpValidator((ResourceCertificateLocator)new ResourceCertificateLocatorImpl(), new X509ResourceCertificate[0]);
        validator.validate("child", this.child);
        Assert.assertFalse((boolean)validator.getValidationResult().hasFailures());
        Assert.assertEquals((Object)validator.getValidationResult().getResult(CHILD_VALIDATION_LOCATION, "cert.key.cert.sign"), (Object)new ValidationCheck(ValidationStatus.WARNING, "cert.key.cert.sign", new String[0]));
    }

    @Test
    public void testShouldFailOnMissingAKI() {
        this.child = this.createChildBuilder().withAuthorityKeyIdentifier(false).build();
        X509ResourceCertificateBottomUpValidator validator = new X509ResourceCertificateBottomUpValidator((ResourceCertificateLocator)new ResourceCertificateLocatorImpl(), new X509ResourceCertificate[0]);
        validator.validate("child", this.child);
        Assert.assertTrue((boolean)validator.getValidationResult().hasFailures());
        Assert.assertTrue((boolean)validator.getValidationResult().hasFailureForLocation(CHILD_VALIDATION_LOCATION));
        Assert.assertTrue((boolean)"cert.aki.present".equals(((ValidationCheck)validator.getValidationResult().getFailures(CHILD_VALIDATION_LOCATION).get(0)).getKey()));
    }

    @Test
    public void testShouldFailOnCrlCheck() throws CRLException {
        this.child = this.createChildBuilder().build();
        this.grandchild = this.createSecondChildBuilder().build();
        this.rootCrl = this.getRootCRL().addEntry(FIRST_CHILD_SERIAL_NUMBER, VALIDITY_PERIOD.getNotValidBefore().plusDays(2)).build(ROOT_KEY_PAIR.getPrivate());
        X509ResourceCertificateBottomUpValidator validator = new X509ResourceCertificateBottomUpValidator((ResourceCertificateLocator)new ResourceCertificateLocatorImpl(), new X509ResourceCertificate[0]);
        validator.validate("child", this.child);
        ValidationResult validationResult = validator.getValidationResult();
        Assert.assertTrue((boolean)validationResult.hasFailures());
        Assert.assertTrue((boolean)validationResult.hasFailureForLocation(CHILD_VALIDATION_LOCATION));
        Assert.assertTrue((boolean)"cert.not.revoked".equals(((ValidationCheck)validationResult.getFailures(CHILD_VALIDATION_LOCATION).get(0)).getKey()));
    }

    @Test
    public void testShouldFailWhenCrlInvalid() {
        this.child = this.createChildBuilder().build();
        this.rootCrl = this.getChildCRL().build(FIRST_CHILD_KEY_PAIR.getPrivate());
        X509ResourceCertificateBottomUpValidator validator = new X509ResourceCertificateBottomUpValidator((ResourceCertificateLocator)new ResourceCertificateLocatorImpl(), new X509ResourceCertificate[0]);
        validator.validate("child", this.child);
        ValidationResult validationResult = validator.getValidationResult();
        Assert.assertTrue((boolean)validationResult.hasFailures());
        Assert.assertTrue((boolean)"cert.crl.signature".equals(((ValidationCheck)validationResult.getFailures(CHILD_VALIDATION_LOCATION).get(0)).getKey()));
    }

    private X509ResourceCertificate getRootResourceCertificate() {
        X509ResourceCertificateBuilder builder = new X509ResourceCertificateBuilder();
        builder.withSubjectDN(ROOT_CERTIFICATE_NAME);
        builder.withIssuerDN(ROOT_CERTIFICATE_NAME);
        builder.withSerial(ROOT_SERIAL_NUMBER);
        builder.withValidityPeriod(VALIDITY_PERIOD);
        builder.withPublicKey(ROOT_KEY_PAIR.getPublic());
        builder.withCa(true);
        builder.withKeyUsage(6);
        builder.withAuthorityKeyIdentifier(true);
        builder.withResources(ROOT_RESOURCE_SET);
        builder.withAuthorityKeyIdentifier(false);
        builder.withSubjectInformationAccess(new X509CertificateInformationAccessDescriptor[]{new X509CertificateInformationAccessDescriptor(X509CertificateInformationAccessDescriptor.ID_AD_CA_REPOSITORY, URI.create("rsync://example.com/root/")), new X509CertificateInformationAccessDescriptor(X509CertificateInformationAccessDescriptor.ID_AD_RPKI_MANIFEST, URI.create("rsync://example.com/root/manifest.mft"))});
        builder.withSigningKeyPair(ROOT_KEY_PAIR);
        return builder.build();
    }

    private X509ResourceCertificateBuilder createChildBuilder() {
        X509ResourceCertificateBuilder builder = new X509ResourceCertificateBuilder();
        builder.withSubjectDN(FIRST_CHILD_CERTIFICATE_NAME);
        builder.withIssuerDN(ROOT_CERTIFICATE_NAME);
        builder.withSerial(FIRST_CHILD_SERIAL_NUMBER);
        builder.withPublicKey(FIRST_CHILD_KEY_PAIR.getPublic());
        builder.withAuthorityKeyIdentifier(true);
        builder.withSigningKeyPair(ROOT_KEY_PAIR);
        builder.withCa(true);
        builder.withKeyUsage(6);
        builder.withAuthorityKeyIdentifier(true);
        builder.withInheritedResourceTypes(EnumSet.allOf(IpResourceType.class));
        builder.withValidityPeriod(VALIDITY_PERIOD);
        builder.withCrlDistributionPoints(new URI[]{URI.create("rsync://localhost/ta.crl")});
        builder.withSubjectInformationAccess(new X509CertificateInformationAccessDescriptor[]{new X509CertificateInformationAccessDescriptor(X509CertificateInformationAccessDescriptor.ID_AD_CA_REPOSITORY, URI.create("rsync://example.com/repository/")), new X509CertificateInformationAccessDescriptor(X509CertificateInformationAccessDescriptor.ID_AD_RPKI_MANIFEST, URI.create("rsync://example.com/repository/manifest.mft"))});
        return builder;
    }

    private X509ResourceCertificateBuilder createSecondChildBuilder() {
        X509ResourceCertificateBuilder builder = new X509ResourceCertificateBuilder();
        builder.withSubjectDN(SECOND_CHILD_CERTIFICATE_NAME);
        builder.withIssuerDN(FIRST_CHILD_CERTIFICATE_NAME);
        builder.withSerial(SECOND_CHILD_SERIAL_NUMBER);
        builder.withPublicKey(SECOND_CHILD_KEY_PAIR.getPublic());
        builder.withAuthorityKeyIdentifier(true);
        builder.withSigningKeyPair(FIRST_CHILD_KEY_PAIR);
        builder.withCa(true);
        builder.withKeyUsage(6);
        builder.withValidityPeriod(VALIDITY_PERIOD);
        builder.withAuthorityKeyIdentifier(true);
        builder.withResources(CHILD_RESOURCE_SET);
        builder.withCrlDistributionPoints(new URI[]{URI.create("rsync://localhost/prod.crl")});
        return builder;
    }

    private X509CrlBuilder getRootCRL() {
        X509CrlBuilder builder = new X509CrlBuilder();
        builder.withIssuerDN(ROOT_CERTIFICATE_NAME);
        builder.withThisUpdateTime(VALIDITY_PERIOD.getNotValidBefore().plusDays(1));
        builder.withNextUpdateTime(UTC.dateTime().plusMonths(1));
        builder.withNumber(BigInteger.valueOf(1L));
        builder.withAuthorityKeyIdentifier(ROOT_KEY_PAIR.getPublic());
        builder.withSignatureProvider("SunRsaSign");
        return builder;
    }

    private X509CrlBuilder getChildCRL() {
        X509CrlBuilder builder = new X509CrlBuilder();
        builder.withIssuerDN(FIRST_CHILD_CERTIFICATE_NAME);
        builder.withThisUpdateTime(VALIDITY_PERIOD.getNotValidBefore().plusDays(1));
        builder.withNextUpdateTime(UTC.dateTime().plusMonths(1));
        builder.withNumber(BigInteger.valueOf(1L));
        builder.withAuthorityKeyIdentifier(FIRST_CHILD_KEY_PAIR.getPublic());
        builder.withSignatureProvider("SunRsaSign");
        return builder;
    }

    private class ResourceCertificateLocatorImpl
    implements ResourceCertificateLocator {
        private ResourceCertificateLocatorImpl() {
        }

        public CertificateRepositoryObjectFile<X509ResourceCertificate> findParent(X509ResourceCertificate certificate) {
            Validate.isTrue((!certificate.isRoot() ? 1 : 0) != 0);
            if (certificate.equals((Object)X509ResourceCertificateBottomUpValidatorTest.this.grandchild)) {
                return new CertificateRepositoryObjectFile(X509ResourceCertificate.class, "child", X509ResourceCertificateBottomUpValidatorTest.this.child.getEncoded());
            }
            if (certificate.equals((Object)X509ResourceCertificateBottomUpValidatorTest.this.child)) {
                return new CertificateRepositoryObjectFile(X509ResourceCertificate.class, "root", X509ResourceCertificateBottomUpValidatorTest.this.root.getEncoded());
            }
            throw new IllegalArgumentException("unable to find parent for certificate: " + certificate);
        }

        public CertificateRepositoryObjectFile<X509Crl> findCrl(X509ResourceCertificate certificate) {
            if (certificate.equals((Object)X509ResourceCertificateBottomUpValidatorTest.this.child)) {
                return new CertificateRepositoryObjectFile(X509Crl.class, "rootCrl", X509ResourceCertificateBottomUpValidatorTest.this.rootCrl.getEncoded());
            }
            if (certificate.equals((Object)X509ResourceCertificateBottomUpValidatorTest.this.grandchild)) {
                return new CertificateRepositoryObjectFile(X509Crl.class, "childCrl", X509ResourceCertificateBottomUpValidatorTest.this.childCrl.getEncoded());
            }
            return null;
        }
    }
}

