/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.payload.error;

import java.util.ArrayList;
import net.ripe.rpki.commons.provisioning.payload.AbstractProvisioningPayloadXmlSerializer;
import net.ripe.rpki.commons.provisioning.payload.PayloadMessageType;
import net.ripe.rpki.commons.provisioning.payload.error.NotPerformedError;
import net.ripe.rpki.commons.provisioning.payload.error.RequestNotPerformedResponsePayload;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RequestNotPerformedResponsePayloadSerializer
extends AbstractProvisioningPayloadXmlSerializer<RequestNotPerformedResponsePayload> {
    public RequestNotPerformedResponsePayloadSerializer() {
        super(PayloadMessageType.error_response);
    }

    @Override
    protected RequestNotPerformedResponsePayload parseXmlPayload(Element messageElement) {
        Element statusElement = this.getSingleChildElement(messageElement, "status");
        String description = this.getChildElements(messageElement, "description").stream().findFirst().map(Node::getTextContent).orElse(null);
        return new RequestNotPerformedResponsePayload(NotPerformedError.getError(Integer.parseInt(statusElement.getTextContent().trim())), description);
    }

    @Override
    protected Iterable<? extends Node> generateXmlPayload(Document document, RequestNotPerformedResponsePayload payload) {
        ArrayList<Element> result = new ArrayList<Element>();
        Element statusElement = document.createElementNS(this.xmlns, "status");
        statusElement.setTextContent(String.valueOf(payload.getStatus().getErrorCode()));
        result.add(statusElement);
        if (payload.getDescription() != null) {
            Element descriptionElement = document.createElementNS(this.xmlns, "description");
            descriptionElement.setAttribute("xml:lang", "en-US");
            descriptionElement.setTextContent(payload.getDescription());
            result.add(descriptionElement);
        }
        return result;
    }
}

