/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.rfc3779;

import java.util.ArrayList;
import java.util.SortedMap;
import java.util.TreeMap;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpAddress;
import net.ripe.ipresource.IpRange;
import net.ripe.ipresource.IpResource;
import net.ripe.ipresource.IpResourceRange;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.ipresource.IpResourceType;
import net.ripe.ipresource.UniqueIpResource;
import net.ripe.rpki.commons.crypto.rfc3779.AddressFamily;
import net.ripe.rpki.commons.crypto.util.Asn1Util;
import org.apache.commons.lang3.Validate;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class ResourceExtensionEncoder {
    public static final String OID_PKIX = "1.3.6.1.5.5.7";
    public static final String OID_PE = "1.3.6.1.5.5.7.1";
    public static final ASN1ObjectIdentifier OID_IP_ADDRESS_BLOCKS = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.1.7");
    public static final ASN1ObjectIdentifier OID_AUTONOMOUS_SYS_IDS = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.1.8");

    public ASN1Object encodeIpAddressBlocks(boolean inheritIpv4, boolean inheritIpv6, IpResourceSet resources) {
        TreeMap<AddressFamily, IpResourceSet> addressBlocks = new TreeMap<AddressFamily, IpResourceSet>();
        if (inheritIpv4) {
            addressBlocks.put(AddressFamily.IPV4, null);
        } else if (resources.containsType(IpResourceType.IPv4)) {
            addressBlocks.put(AddressFamily.IPV4, resources);
        }
        if (inheritIpv6) {
            addressBlocks.put(AddressFamily.IPV6, null);
        } else if (resources.containsType(IpResourceType.IPv6)) {
            addressBlocks.put(AddressFamily.IPV6, resources);
        }
        return addressBlocks.isEmpty() ? null : this.ipAddressBlocksToDer(addressBlocks);
    }

    public ASN1Object encodeAsIdentifiers(boolean inherit, IpResourceSet resources) {
        if (inherit || resources.containsType(IpResourceType.ASN)) {
            return this.asIdentifiersToDer(inherit, resources, false, new IpResourceSet());
        }
        return null;
    }

    ASN1Object asIdentifiersToDer(boolean inheritAsn, IpResourceSet asnResources, boolean inheritRdi, IpResourceSet rdiResources) {
        ArrayList<DERTaggedObject> seq = new ArrayList<DERTaggedObject>(2);
        if (inheritAsn || asnResources.containsType(IpResourceType.ASN)) {
            seq.add(new DERTaggedObject(0, this.asIdentifierChoiceToDer(inheritAsn, asnResources)));
        }
        if (inheritRdi || rdiResources.containsType(IpResourceType.ASN)) {
            seq.add(new DERTaggedObject(1, this.asIdentifierChoiceToDer(inheritRdi, rdiResources)));
        }
        return new DERSequence(seq.toArray(new ASN1Encodable[seq.size()]));
    }

    ASN1Encodable asIdentifierChoiceToDer(boolean inherit, IpResourceSet resources) {
        return inherit ? DERNull.INSTANCE : this.asIdsOrRangesToDer(resources);
    }

    DERSequence asIdsOrRangesToDer(IpResourceSet resources) {
        ArrayList<ASN1Encodable> seq = new ArrayList<ASN1Encodable>();
        for (IpResource resource : resources) {
            if (IpResourceType.ASN != resource.getType()) continue;
            seq.add(this.asIdOrRangeToDer(IpResourceRange.range((UniqueIpResource)resource.getStart(), (UniqueIpResource)resource.getEnd())));
        }
        return new DERSequence(seq.toArray(new ASN1Encodable[seq.size()]));
    }

    ASN1Encodable asIdOrRangeToDer(IpResourceRange range) {
        return range.isUnique() ? this.asIdToDer((Asn)range.getStart()) : this.asRangeToDer(range);
    }

    DERSequence asRangeToDer(IpResourceRange range) {
        ASN1Encodable[] seq = new ASN1Encodable[]{this.asIdToDer((Asn)range.getStart()), this.asIdToDer((Asn)range.getEnd())};
        return new DERSequence(seq);
    }

    ASN1Integer asIdToDer(Asn asn) {
        return new ASN1Integer(asn.getValue());
    }

    ASN1Object ipAddressBlocksToDer(SortedMap<AddressFamily, IpResourceSet> resources) {
        ArrayList<ASN1Object> seq = new ArrayList<ASN1Object>(2);
        for (AddressFamily addressFamily : resources.keySet()) {
            seq.add(this.ipAddressFamilyToDer(addressFamily, (IpResourceSet)resources.get(addressFamily)));
        }
        return new DERSequence(seq.toArray(new ASN1Encodable[seq.size()]));
    }

    ASN1Object ipAddressFamilyToDer(AddressFamily addressFamily, IpResourceSet resources) {
        IpResourceType type = addressFamily.toIpResourceType();
        ASN1Encodable[] seq = new ASN1Encodable[]{addressFamily.toDer(), this.ipAddressChoiceToDer(type, resources)};
        return new DERSequence(seq);
    }

    ASN1Encodable ipAddressChoiceToDer(IpResourceType type, IpResourceSet resources) {
        if (resources == null) {
            return DERNull.INSTANCE;
        }
        ArrayList<ASN1Encodable> addressesOrRanges = new ArrayList<ASN1Encodable>();
        for (IpResource resource : resources) {
            if (resource.getType() != type) continue;
            addressesOrRanges.add(this.ipAddressOrRangeToDer(this.asRange(resource)));
        }
        Validate.notEmpty(addressesOrRanges, (String)("no resources of type " + type + " in set"), (Object[])new Object[0]);
        return new DERSequence(addressesOrRanges.toArray(new ASN1Encodable[addressesOrRanges.size()]));
    }

    private IpRange asRange(IpResource resource) {
        return IpRange.range((IpAddress)((IpAddress)resource.getStart()), (IpAddress)((IpAddress)resource.getEnd()));
    }

    ASN1Encodable ipAddressOrRangeToDer(IpRange range) {
        return range.isLegalPrefix() ? Asn1Util.encodeIpAddress(range) : this.ipRangeToDer(range);
    }

    DERSequence ipRangeToDer(IpRange range) {
        ASN1Encodable[] encodables = new ASN1Encodable[]{ResourceExtensionEncoder.startIpAddressToDer((IpAddress)range.getStart()), ResourceExtensionEncoder.endIpAddressToDer((IpAddress)range.getEnd())};
        return new DERSequence(encodables);
    }

    private static DERBitString startIpAddressToDer(IpAddress address) {
        int lastOne = address.getLeastSignificantOne();
        return Asn1Util.resourceToBitString((UniqueIpResource)address, address.getType().getBitSize() - lastOne);
    }

    private static DERBitString endIpAddressToDer(IpAddress address) {
        int lastOne = address.getLeastSignificantZero();
        return Asn1Util.resourceToBitString((UniqueIpResource)address.stripLeastSignificantOnes(), address.getType().getBitSize() - lastOne);
    }
}

