/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.xml;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.security.ForbiddenClassException;
import java.sql.Timestamp;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.security.auth.x500.X500Principal;
import net.ripe.ipresource.IpResource;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCms;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCmsTest;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCms;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCmsTest;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateTest;
import net.ripe.rpki.commons.util.UTC;
import net.ripe.rpki.commons.util.VersionedId;
import net.ripe.rpki.commons.xml.XStreamXmlSerializer;
import net.ripe.rpki.commons.xml.XStreamXmlSerializerBuilder;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Test;

public class XStreamXmlSerializerBuilderTest {
    private static final boolean NOT_STRICT = false;

    @Test
    public void shouldCreateSerializer() {
        XStreamXmlSerializerBuilder builder = new XStreamXmlSerializerBuilder(String.class, false);
        XStreamXmlSerializer serializer = builder.build();
        String serializedData = serializer.serialize((Object)"foo");
        Assert.assertEquals((Object)"<string>foo</string>", (Object)serializedData);
    }

    @Test
    public void shouldAliasCommonsPackage() {
        XStreamXmlSerializerBuilder builder = new XStreamXmlSerializerBuilder(ValidityPeriod.class, false);
        XStreamXmlSerializer serializer = builder.build();
        String serializedData = serializer.serialize((Object)new ValidityPeriod());
        Assert.assertEquals((Object)"<ValidityPeriod/>", (Object)serializedData);
    }

    @Test
    public void shouldAliasIpResourceAndUseConverter() {
        XStreamXmlSerializerBuilder builder = new XStreamXmlSerializerBuilder(IpResource.class, false);
        XStreamXmlSerializer serializer = builder.build();
        IpResource ipResource = IpResource.parse((String)"10/8");
        String serializedData = serializer.serialize((Object)ipResource);
        Assert.assertEquals((Object)"<resource>10.0.0.0/8</resource>", (Object)serializedData);
        Assert.assertEquals((Object)ipResource, (Object)serializer.deserialize(serializedData));
    }

    @Test
    public void shouldAliasIpResourceSetAndUseConverter() {
        XStreamXmlSerializerBuilder builder = new XStreamXmlSerializerBuilder(IpResourceSet.class, false);
        XStreamXmlSerializer serializer = builder.build();
        IpResourceSet ipResourceSet = IpResourceSet.parse((String)"10/8");
        String serializedData = serializer.serialize((Object)ipResourceSet);
        Assert.assertEquals((Object)"<resource-set>10.0.0.0/8</resource-set>", (Object)serializedData);
        Assert.assertEquals((Object)ipResourceSet, (Object)serializer.deserialize(serializedData));
    }

    @Test
    public void shouldAliasDateTimeAndUseConverter() {
        XStreamXmlSerializerBuilder builder = new XStreamXmlSerializerBuilder(DateTime.class, false);
        XStreamXmlSerializer serializer = builder.build();
        DateTime dateTime = new DateTime(2011, 1, 31, 13, 59, 59, 0, DateTimeZone.UTC);
        String serializedData = serializer.serialize((Object)dateTime);
        Assert.assertEquals((Object)"<datetime>2011-01-31T13:59:59Z</datetime>", (Object)serializedData);
        Assert.assertEquals((Object)dateTime, (Object)serializer.deserialize(serializedData));
    }

    @Test
    public void shouldConvertDateTimeFromTimeStamp() {
        XStreamXmlSerializerBuilder builder = new XStreamXmlSerializerBuilder(Timestamp.class, false);
        XStreamXmlSerializer serializer = builder.build();
        Timestamp timestamp = new Timestamp(new DateTime(2011, 1, 31, 13, 59, 59, 0, DateTimeZone.UTC).getMillis());
        String serializedData = serializer.serialize((Object)timestamp);
        Assert.assertEquals((Object)"<sql-timestamp>2011-01-31T13:59:59.000Z</sql-timestamp>", (Object)serializedData);
        Assert.assertEquals((Object)timestamp, (Object)serializer.deserialize(serializedData));
    }

    @Test
    public void shouldConvertDateTimeFromReadablePeriod() {
        XStreamXmlSerializerBuilder builder = new XStreamXmlSerializerBuilder(Period.class, false);
        XStreamXmlSerializer serializer = builder.build();
        DateTime now = UTC.dateTime();
        Period period = new Period((ReadableInstant)now, (ReadableInstant)now.plusHours(1));
        String serializedData = serializer.serialize((Object)period);
        Assert.assertEquals((Object)"<org.joda.time.Period>PT1H</org.joda.time.Period>", (Object)serializedData);
        Assert.assertEquals((Object)period, (Object)serializer.deserialize(serializedData));
    }

    @Test
    public void shouldAliasPrincipalAndUseConverter() {
        XStreamXmlSerializerBuilder builder = new XStreamXmlSerializerBuilder(X500Principal.class, false);
        XStreamXmlSerializer serializer = builder.build();
        X500Principal principal = new X500Principal("CN=nl.bluelight");
        String serializedData = serializer.serialize((Object)principal);
        Assert.assertEquals((Object)"<principal>CN=nl.bluelight</principal>", (Object)serializedData);
        Assert.assertEquals((Object)principal, (Object)serializer.deserialize(serializedData));
    }

    @Test
    public void shouldConvertVersionedId() {
        XStreamXmlSerializerBuilder builder = new XStreamXmlSerializerBuilder(VersionedId.class, false);
        XStreamXmlSerializer serializer = builder.build();
        VersionedId versionedId = new VersionedId(1L, 2L);
        String serializedData = serializer.serialize((Object)versionedId);
        Assert.assertEquals((Object)"<versionedId>1:2</versionedId>", (Object)serializedData);
        Assert.assertEquals((Object)versionedId, (Object)serializer.deserialize(serializedData));
    }

    @Test
    public void shouldConvertX509ResourceCertificate() {
        XStreamXmlSerializerBuilder builder = new XStreamXmlSerializerBuilder(X509ResourceCertificate.class, false);
        XStreamXmlSerializer serializer = builder.build();
        X509ResourceCertificate resourceCertificate = X509ResourceCertificateTest.createSelfSignedCaResourceCertificate();
        String serializedData = serializer.serialize((Object)resourceCertificate);
        Assert.assertTrue((boolean)Pattern.matches("<X509ResourceCertificate>\\s*<encoded>[^<]+</encoded>\\s*</X509ResourceCertificate>", serializedData));
        Assert.assertEquals((Object)resourceCertificate, (Object)serializer.deserialize(serializedData));
    }

    @Test
    public void shouldConvertManifestCms() {
        XStreamXmlSerializerBuilder builder = new XStreamXmlSerializerBuilder(ManifestCms.class, false);
        XStreamXmlSerializer serializer = builder.build();
        ManifestCms manifestCms = ManifestCmsTest.getRootManifestCms();
        String serializedData = serializer.serialize((Object)manifestCms);
        Assert.assertTrue((boolean)Pattern.matches("<ManifestCms>\\s*<encoded>[^<]+</encoded>\\s*</ManifestCms>", serializedData));
        Assert.assertEquals((Object)manifestCms, (Object)serializer.deserialize(serializedData));
    }

    @Test
    public void shouldConvertRoaCms() {
        XStreamXmlSerializerBuilder builder = new XStreamXmlSerializerBuilder(RoaCms.class, false);
        XStreamXmlSerializer serializer = builder.build();
        RoaCms roaCms = RoaCmsTest.getRoaCms();
        String serializedData = serializer.serialize((Object)roaCms);
        Assert.assertTrue((boolean)Pattern.matches("<RoaCms>\\s*<encoded>[^<]+</encoded>\\s*</RoaCms>", serializedData));
        Assert.assertEquals((Object)roaCms, (Object)serializer.deserialize(serializedData));
    }

    @Test
    public void shouldIgnoreUnknownElements() {
        XStreamXmlSerializerBuilder builder = new XStreamXmlSerializerBuilder(String.class, false);
        XStreamXmlSerializer serializer = builder.build();
        String deserializedData = (String)serializer.deserialize("<string>sample string</string><foo/>");
        Assert.assertEquals((Object)"sample string", (Object)deserializedData);
    }

    @Test
    public void shouldAliasPackage() {
        XStreamXmlSerializerBuilder builder = new XStreamXmlSerializerBuilder(SerializeMe.class, false);
        builder.withAliasPackage("test-alias", SerializeMe.class.getPackage().getName());
        XStreamXmlSerializer serializer = builder.build();
        String serializedData = serializer.serialize((Object)new SerializeMe());
        Assert.assertEquals((Object)"<test-alias.XStreamXmlSerializerBuilderTest_-SerializeMe/>", (Object)serializedData);
    }

    @Test
    public void shouldDeserializeOwnType() {
        XStreamXmlSerializerBuilder builder = new XStreamXmlSerializerBuilder(SerializeMe.class, false);
        XStreamXmlSerializer serializer = builder.build();
        String serializedData = serializer.serialize((Object)new SerializeMe());
        serializer.deserialize(serializedData);
        Assert.assertEquals((Object)"<net.ripe.rpki.commons.xml.XStreamXmlSerializerBuilderTest_-SerializeMe/>", (Object)serializedData);
    }

    @Test(expected=ForbiddenClassException.class)
    public void shouldNotDeserializeUnknownType() {
        XStreamXmlSerializerBuilder builder = new XStreamXmlSerializerBuilder(SerializeMe.class, false);
        XStreamXmlSerializer deserializer = builder.build();
        XStreamXmlSerializer otherSerializer = new XStreamXmlSerializerBuilder(OtherSerializeMe.class, false).build();
        String serializedData = otherSerializer.serialize((Object)new OtherSerializeMe(new SerializeMe()));
        deserializer.deserialize(serializedData);
    }

    @Test
    public void shouldAllowExplicitlyAllowedType() {
        XStreamXmlSerializerBuilder builder = new XStreamXmlSerializerBuilder(OtherSerializeMe.class, false);
        builder.withAllowedType(SerializeMe.class);
        XStreamXmlSerializer serializer = builder.build();
        OtherSerializeMe input = new OtherSerializeMe(new SerializeMe());
        String serializedData = serializer.serialize((Object)input);
        OtherSerializeMe output = (OtherSerializeMe)serializer.deserialize(serializedData);
        Assert.assertEquals((Object)input.canBeAnything, (Object)output.canBeAnything);
    }

    @Test
    public void shouldAllowArrayOfExplicitlyAllowedType() {
        XStreamXmlSerializerBuilder builder = new XStreamXmlSerializerBuilder(OtherSerializeMe.class, false);
        builder.withAllowedType(SerializeMe.class);
        XStreamXmlSerializer serializer = builder.build();
        OtherSerializeMe input = new OtherSerializeMe(new SerializeMe[]{new SerializeMe(), new SerializeMe()});
        String serializedData = serializer.serialize((Object)input);
        OtherSerializeMe output = (OtherSerializeMe)serializer.deserialize(serializedData);
        Assert.assertArrayEquals((Object[])((Object[])input.canBeAnything), (Object[])((Object[])output.canBeAnything));
    }

    @Test
    public void shouldSerializeHierarchy() {
        XStreamXmlSerializer serializer = new XStreamXmlSerializerBuilder(SerializeMeInterface.class, false).build();
        String serializedData = serializer.serialize((Object)new SerializeMe());
        SerializeMeInterface output = (SerializeMeInterface)serializer.deserialize(serializedData);
        Assert.assertEquals((Object)new SerializeMe(), (Object)output);
    }

    @Test
    public void shouldSerializeAllowedHierarchy() {
        XStreamXmlSerializerBuilder builder = new XStreamXmlSerializerBuilder(WithSerializeMeInterfaceField.class, false);
        builder.withAllowedTypeHierarchy(SerializeMeInterface.class);
        XStreamXmlSerializer serializer = builder.build();
        WithSerializeMeInterfaceField input = new WithSerializeMeInterfaceField(new SerializeMe());
        String serializedData = serializer.serialize((Object)input);
        WithSerializeMeInterfaceField output = (WithSerializeMeInterfaceField)serializer.deserialize(serializedData);
        Assert.assertEquals((Object)input, (Object)output);
    }

    @Test
    public void shouldAllowAliasedConcreteTypeInObjectField() {
        XStreamXmlSerializerBuilder builder = new XStreamXmlSerializerBuilder(OtherSerializeMe.class, false);
        builder.withAliasType("serialize-me", SerializeMe.class);
        XStreamXmlSerializer serializer = builder.build();
        String serializedData = serializer.serialize((Object)new OtherSerializeMe(new SerializeMe()));
        Assert.assertTrue((boolean)serializedData.contains("serialize-me"));
        serializer.deserialize(serializedData);
    }

    @Test
    public void shouldAllowConcreteTypeFromAliasedPackageInObjectField() {
        XStreamXmlSerializerBuilder builder = new XStreamXmlSerializerBuilder(OtherSerializeMe.class, false);
        builder.withAliasPackage("rpki-commons-xml", "net.ripe.rpki.commons.xml");
        XStreamXmlSerializer serializer = builder.build();
        String serializedData = serializer.serialize((Object)new OtherSerializeMe(new SerializeMe()));
        Assert.assertTrue((boolean)serializedData.contains("rpki-commons-xml"));
        serializer.deserialize(serializedData);
    }

    @Test(expected=ForbiddenClassException.class)
    public void shouldNotDeserializeUnknownTypeInObjectField() throws Throwable {
        XStreamXmlSerializerBuilder builder = new XStreamXmlSerializerBuilder(OtherSerializeMe.class, false);
        XStreamXmlSerializer serializer = builder.build();
        String serializedData = serializer.serialize((Object)new OtherSerializeMe(new SerializeMe()));
        try {
            serializer.deserialize(serializedData);
        }
        catch (ConversionException e) {
            throw e.getCause();
        }
    }

    @Test(expected=ConversionException.class)
    public void shouldNotPopCalculatorApp() {
        XStreamXmlSerializer builder = new XStreamXmlSerializerBuilder(SerializeMe.class, false).build();
        builder.deserialize("<sorted-set>\n    <string>foo</string>\n    <dynamic-proxy>\n        <interface>java.lang.Comparable</interface>\n        <handler class=\"java.beans.EventHandler\">\n            <target class=\"java.lang.ProcessBuilder\">\n                <command>\n                    <string>open</string>\n                    <string>/Applications/Calculator.app</string>\n                </command>\n            </target>\n            <action>start</action>\n        </handler>\n    </dynamic-proxy>\n</sorted-set>");
    }

    private static class WithSerializeMeInterfaceField {
        SerializeMeInterface inner;

        public WithSerializeMeInterfaceField(SerializeMeInterface inner) {
            this.inner = inner;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WithSerializeMeInterfaceField that = (WithSerializeMeInterfaceField)o;
            return Objects.equals(this.inner, that.inner);
        }

        public int hashCode() {
            return Objects.hash(this.inner);
        }
    }

    private static class OtherSerializeMe
    implements SerializeMeInterface {
        Object canBeAnything;

        public OtherSerializeMe(Object canBeAnything) {
            this.canBeAnything = canBeAnything;
        }
    }

    private static class SerializeMe
    implements SerializeMeInterface {
        private SerializeMe() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return 1;
        }
    }

    private static interface SerializeMeInterface {
    }
}

