/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.validation.properties;

import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.math.BigInteger;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpAddress;
import net.ripe.ipresource.IpRange;
import net.ripe.ipresource.IpResource;
import net.ripe.ipresource.Ipv4Address;
import net.ripe.ipresource.Ipv6Address;

public class ResourceGenerator {
    private static final BigInteger MAX_IPV6 = BigInteger.ONE.shiftLeft(128).subtract(BigInteger.ONE);

    static IpResource generateIpResource(SourceOfRandomness sourceOfRandomness) {
        int what = sourceOfRandomness.nextInt(20);
        if (what < 3) {
            return ResourceGenerator.generateAsn(sourceOfRandomness);
        }
        if (what < 15) {
            return ResourceGenerator.generateV4Prefix(sourceOfRandomness);
        }
        return ResourceGenerator.generateV6Prefix(sourceOfRandomness);
    }

    static IpResource generateAsn(SourceOfRandomness sourceOfRandomness) {
        return new Asn(sourceOfRandomness.nextLong(0L, 0xFFFFFFFFL));
    }

    static IpResource generateV4Prefix(SourceOfRandomness sourceOfRandomness) {
        long maxV4Ip = 0xFFFFFFFFL;
        long base = sourceOfRandomness.nextLong(1L, 0xFFFFFFFFL);
        int prefixLength = sourceOfRandomness.nextInt(8, 32);
        long mask = 0xFFFFFFFFL << 32 - prefixLength;
        long begin = base & mask;
        long end = base | (mask ^ 0xFFFFFFFFFFFFFFFFL) & 0xFFFFFFFFL;
        return IpRange.range((IpAddress)new Ipv4Address(begin), (IpAddress)new Ipv4Address(end));
    }

    static IpResource generateV6Prefix(SourceOfRandomness sourceOfRandomness) {
        BigInteger base = sourceOfRandomness.nextBigInteger(128);
        int prefixLength = sourceOfRandomness.nextInt(46, 128);
        BigInteger mask = MAX_IPV6.shiftLeft(128 - prefixLength);
        BigInteger begin = base.and(mask);
        BigInteger end = base.or(mask.not()).and(MAX_IPV6);
        return IpRange.range((IpAddress)new Ipv6Address(begin), (IpAddress)new Ipv6Address(end));
    }
}

