/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.interop;

import com.google.common.io.BaseEncoding;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.ripe.rpki.commons.provisioning.cms.ProvisioningCmsObject;
import net.ripe.rpki.commons.provisioning.cms.ProvisioningCmsObjectParser;
import net.ripe.rpki.commons.provisioning.cms.ProvisioningCmsObjectValidator;
import net.ripe.rpki.commons.provisioning.identity.ChildIdentity;
import net.ripe.rpki.commons.provisioning.identity.ChildIdentitySerializer;
import net.ripe.rpki.commons.provisioning.identity.ParentIdentity;
import net.ripe.rpki.commons.provisioning.identity.ParentIdentitySerializer;
import net.ripe.rpki.commons.provisioning.payload.issue.request.CertificateIssuanceRequestPayload;
import net.ripe.rpki.commons.provisioning.x509.ProvisioningIdentityCertificate;
import net.ripe.rpki.commons.provisioning.x509.pkcs10.RpkiCaCertificateRequestParser;
import net.ripe.rpki.commons.provisioning.x509.pkcs10.RpkiCaCertificateRequestParserException;
import net.ripe.rpki.commons.validation.ValidationCheck;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationOptions;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.ValidationStatus;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.junit.Assert;
import org.junit.Test;

public class ProcessIscUpdownPdusTest {
    private static final String PATH_TO_TEST_PDUS = "src/test/resources/isc-interop-updown";

    @Test
    public void shouldParseCertificateIssuanceRequest() throws IOException, RpkiCaCertificateRequestParserException {
        byte[] encoded = Files.toByteArray((File)new File("src/test/resources/isc-interop-updown/pdu.200.der"));
        ProvisioningCmsObjectParser parser = new ProvisioningCmsObjectParser();
        parser.parseCms("cms", encoded);
        ValidationResult validationResult = parser.getValidationResult();
        for (ValidationCheck check : validationResult.getFailures(new ValidationLocation("cms"))) {
            System.err.println("Failure: " + check);
        }
        ProvisioningCmsObject provisioningCmsObject = parser.getProvisioningCmsObject();
        CertificateIssuanceRequestPayload payload = (CertificateIssuanceRequestPayload)provisioningCmsObject.getPayload();
        PKCS10CertificationRequest certificateRequest = payload.getRequestElement().getCertificateRequest();
        RpkiCaCertificateRequestParser rpkiCaCertificateRequestParser = new RpkiCaCertificateRequestParser(certificateRequest);
        Assert.assertNotNull((Object)rpkiCaCertificateRequestParser.getCaRepositoryUri());
        Assert.assertNotNull((Object)rpkiCaCertificateRequestParser.getManifestUri());
        Assert.assertNotNull((Object)rpkiCaCertificateRequestParser.getPublicKey());
    }

    @Test
    public void shouldReadIscChildIdentityXml() throws IOException {
        ProvisioningIdentityCertificate childCert = this.extractCarolIdentityCert();
        Assert.assertNotNull((Object)childCert);
    }

    @Test
    public void shouldReadIscIssuerXml() throws IOException {
        String parentXml = Files.asCharSource((File)new File("src/test/resources/isc-interop-updown/issuer-alice-child-bob-parent.xml"), (Charset)StandardCharsets.UTF_8).read();
        ParentIdentitySerializer serializer = new ParentIdentitySerializer();
        ParentIdentity parentId = serializer.deserialize(parentXml);
        Assert.assertNotNull((Object)parentId);
    }

    public ProvisioningIdentityCertificate extractCarolIdentityCert() throws IOException {
        String childIdXml = Files.asCharSource((File)new File("src/test/resources/isc-interop-updown/carol-child-id.xml"), (Charset)StandardCharsets.UTF_8).read();
        ChildIdentitySerializer serializer = new ChildIdentitySerializer();
        ChildIdentity childId = serializer.deserialize(childIdXml);
        return childId.getIdentityCertificate();
    }

    @Test
    public void shouldValidateRequest() throws IOException {
        byte[] encoded = Files.toByteArray((File)new File("src/test/resources/isc-interop-updown/pdu.200.der"));
        ProvisioningCmsObjectParser parser = new ProvisioningCmsObjectParser();
        parser.parseCms("cms", encoded);
        ProvisioningCmsObject provisioningCmsObject = parser.getProvisioningCmsObject();
        ProvisioningIdentityCertificate childCert = this.extractCarolIdentityCert();
        ProvisioningCmsObjectValidator validator = new ProvisioningCmsObjectValidator(ValidationOptions.backCompatibleRipeNccValidator(), provisioningCmsObject, childCert);
        ValidationResult result = ValidationResult.withLocation((String)"unknown.der");
        validator.validate(result);
        List failures = result.getFailuresForAllLocations();
        Assert.assertEquals((long)2L, (long)failures.size());
        Assert.assertTrue((boolean)failures.contains(new ValidationCheck(ValidationStatus.ERROR, "cert.not.valid.after", new String[]{"2012-06-30T04:08:03.000Z"})));
        Assert.assertTrue((boolean)failures.contains(new ValidationCheck(ValidationStatus.ERROR, "cert.not.valid.after", new String[]{"2012-06-30T04:07:24.000Z"})));
    }

    @Test
    public void shouldParseAllIscUpDownMessages() throws IOException {
        String[] files;
        for (String fileName : files = new String[]{"pdu.170.der", "pdu.171.der", "pdu.172.der", "pdu.173.der", "pdu.180.der", "pdu.183.der", "pdu.184.der", "pdu.189.der", "pdu.196.der", "pdu.199.der", "pdu.200.der", "pdu.205.der"}) {
            byte[] encoded = Files.toByteArray((File)new File("src/test/resources/isc-interop-updown/" + fileName));
            ProvisioningCmsObjectParser parser = new ProvisioningCmsObjectParser();
            parser.parseCms("cms", encoded);
            Assert.assertFalse((boolean)parser.getValidationResult().hasFailures());
        }
    }

    @Test
    public void shouldParseRpkidParentResponseXml() throws IOException {
        String xml = Files.asCharSource((File)new File("src/test/resources/isc-interop-updown/rpkid-parent-response.xml"), (Charset)StandardCharsets.UTF_8).read();
        ParentIdentitySerializer serializer = new ParentIdentitySerializer();
        ParentIdentity parentId = serializer.deserialize(xml);
        Assert.assertNotNull((Object)parentId);
    }

    @Test
    public void shouldParseRpkidMessageFromDeutscheTelekom() throws IOException {
        String[] files = new String[]{"dtag-outbound-1.der", "dtag-outbound-9.der"};
        BaseEncoding decoder = BaseEncoding.base64().withSeparator("\n", 76);
        for (String fileName : files) {
            String base64Encoded = Files.asCharSource((File)new File("src/test/resources/isc-interop-updown/" + fileName), (Charset)StandardCharsets.UTF_8).read();
            byte[] encoded = decoder.decode((CharSequence)base64Encoded);
            ProvisioningCmsObjectParser parser = new ProvisioningCmsObjectParser();
            parser.parseCms("cms", encoded);
            ValidationResult validationResult = parser.getValidationResult();
            Assert.assertFalse((boolean)validationResult.hasFailures());
        }
    }
}

