/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.util;

import java.security.KeyPair;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.HashMap;
import java.util.Map;
import net.ripe.rpki.commons.crypto.util.KeyPairFactory;
import net.ripe.rpki.commons.crypto.util.PregeneratedKeyPairFactory;
import org.junit.Assert;
import org.junit.Test;

public class KeyPairFactoryTest {
    public static final String DEFAULT_KEYPAIR_GENERATOR_PROVIDER = "SunRsaSign";
    public static KeyPair TEST_KEY_PAIR = PregeneratedKeyPairFactory.getInstance().generate();
    public static KeyPair SECOND_TEST_KEY_PAIR = PregeneratedKeyPairFactory.getInstance().generate();
    private static final Map<String, KeyPair> cachedKeyPairs = new HashMap<String, KeyPair>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyPair getKeyPair(String name) {
        Map<String, KeyPair> map = cachedKeyPairs;
        synchronized (map) {
            KeyPair result = cachedKeyPairs.get(name);
            if (result == null) {
                result = PregeneratedKeyPairFactory.getInstance().generate();
                cachedKeyPairs.put(name, result);
            }
            return result;
        }
    }

    @Test
    public void shouldGenerateRsaKeyPairs() {
        KeyPair keyPair = new KeyPairFactory(DEFAULT_KEYPAIR_GENERATOR_PROVIDER).generate();
        Assert.assertTrue((boolean)(keyPair.getPublic() instanceof RSAPublicKey));
        Assert.assertTrue((boolean)(keyPair.getPrivate() instanceof RSAPrivateKey));
        Assert.assertEquals((Object)keyPair.getPublic(), (Object)KeyPairFactory.decodePublicKey((byte[])keyPair.getPublic().getEncoded()));
        Assert.assertEquals((Object)keyPair.getPrivate(), (Object)KeyPairFactory.decodePrivateKey((byte[])keyPair.getPrivate().getEncoded()));
        RSAPublicKey rsaPublicKey = (RSAPublicKey)keyPair.getPublic();
        Assert.assertEquals((Object)"RSA", (Object)rsaPublicKey.getAlgorithm());
        Assert.assertEquals((long)2048L, (long)rsaPublicKey.getModulus().bitLength());
    }

    @Test(expected=RuntimeException.class)
    public void shouldKeypairGenerationFailOnInvalidProvider() {
        new KeyPairFactory("invalid_provider").generate();
    }

    @Test(expected=RuntimeException.class)
    public void shouldDecodePublicKeyFailOnInvalidInput() {
        KeyPairFactory.decodePublicKey((byte[])new byte[]{0});
    }

    @Test(expected=RuntimeException.class)
    public void shouldDecodePrivateKeyFailOnInvalidInput() {
        KeyPairFactory.decodePrivateKey((byte[])new byte[]{0});
    }
}

