/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms.manifest;

import com.pholser.junit.quickcheck.Property;
import com.pholser.junit.quickcheck.runner.JUnitQuickcheck;
import java.math.BigInteger;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCms;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCmsBuilder;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCmsParser;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCmsParserTest;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.runner.RunWith;

@RunWith(value=JUnitQuickcheck.class)
public class ManifestCMSBuilderPropertyTest {
    @Property
    public void buildEncodedParseCheck(byte[] content, BigInteger manifestNumber, Integer validityHours) {
        ManifestCmsBuilder builder = new ManifestCmsBuilder();
        builder.addFile("test.crl", content);
        builder.withManifestNumber(manifestNumber);
        builder.withSignatureProvider("SunRsaSign");
        builder.withCertificate(ManifestCmsParserTest.createValidManifestEECertificate(ManifestCmsParserTest.TEST_KEY_PAIR));
        DateTime start = DateTime.now();
        builder.withThisUpdateTime(start);
        builder.withNextUpdateTime(start.plusHours(validityHours.intValue()));
        ManifestCms manifestCms = builder.build(ManifestCmsParserTest.TEST_KEY_PAIR.getPrivate());
        ManifestCmsParser mftParser = new ManifestCmsParser();
        mftParser.parse("test.mft", manifestCms.getEncoded());
        Assert.assertTrue((boolean)mftParser.getManifestCms().containsFile("test.crl"));
    }
}

