/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;

public class CsvFormatter {
    private static final char QUOTE_CHAR = '\"';
    private static final String SEPARATOR = ",";
    private List<CsvColumn> columns = new ArrayList<CsvColumn>();
    private Map<CsvColumn, List<String>> rowValues = new HashMap<CsvColumn, List<String>>();
    private int rows = 0;
    private final String separator;

    public CsvFormatter() {
        this(SEPARATOR);
    }

    public CsvFormatter(String separator) {
        this.separator = separator;
    }

    public CsvFormatter addColumn(String heading) {
        this.addColumn(heading, false);
        return this;
    }

    public CsvFormatter addQuotedColumn(String heading) {
        this.addColumn(heading, true);
        return this;
    }

    private void addColumn(String heading, boolean quoteValues) {
        CsvColumn column = new CsvColumn(heading, quoteValues);
        this.columns.add(column);
        this.rowValues.put(column, new ArrayList());
    }

    void setColumnList(List<CsvColumn> columns) {
        this.columns = columns;
    }

    public CsvFormatter addLine(String ... values) {
        Validate.isTrue((this.columns.size() == values.length ? 1 : 0) != 0);
        int columnIndex = 0;
        for (String value : values) {
            CsvColumn column;
            if (value == null) {
                value = "";
            }
            if (!(column = this.columns.get(columnIndex)).hasQuoteValues()) {
                Validate.isTrue((!value.contains(this.separator) ? 1 : 0) != 0);
            }
            this.rowValues.get(column).add(value);
            ++columnIndex;
        }
        ++this.rows;
        return this;
    }

    public void print(File outputFile) throws IOException {
        FileWriter fileWriter = new FileWriter(outputFile);
        this.print(fileWriter, true);
        fileWriter.close();
    }

    public void printWithoutHeaders(Writer out) throws IOException {
        this.print(out, false);
    }

    public void printWithHeaders(Writer out) throws IOException {
        this.print(out, true);
    }

    private void print(Writer out, boolean printHeaders) throws IOException {
        if (printHeaders) {
            this.printHeaders(out);
        }
        for (int i = 0; i < this.rows; ++i) {
            this.printRow(out, i);
        }
    }

    private void printHeaders(Writer out) throws IOException {
        StringBuilder headerLine = new StringBuilder();
        int columnNumber = 1;
        int numberOfColmns = this.columns.size();
        for (CsvColumn col : this.columns) {
            headerLine.append(col.getHeading());
            if (columnNumber < numberOfColmns) {
                headerLine.append(this.separator);
            }
            ++columnNumber;
        }
        out.write(headerLine.toString() + "\n");
    }

    private void printRow(Writer out, int i) throws IOException {
        StringBuilder rowOutput = new StringBuilder();
        int columnNumber = 1;
        int numberOfColumns = this.columns.size();
        for (CsvColumn col : this.columns) {
            this.printValue(i, rowOutput, col);
            if (columnNumber < numberOfColumns) {
                rowOutput.append(this.separator);
            }
            ++columnNumber;
        }
        out.write(rowOutput.toString() + "\n");
    }

    private void printValue(int i, StringBuilder rowOutput, CsvColumn col) {
        if (col.hasQuoteValues()) {
            rowOutput.append('\"');
        }
        rowOutput.append(this.rowValues.get(col).get(i));
        if (col.hasQuoteValues()) {
            rowOutput.append('\"');
        }
    }

    class CsvColumn {
        private String heading;
        private boolean quoteValues;

        public CsvColumn(String heading, boolean quoteValues) {
            this.heading = heading;
            this.quoteValues = quoteValues;
        }

        public String getHeading() {
            return this.heading;
        }

        public boolean hasQuoteValues() {
            return this.quoteValues;
        }
    }
}

