/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.ta.serializers;

import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.security.auth.x500.X500Principal;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateInformationAccessDescriptor;
import net.ripe.rpki.commons.ta.domain.request.ResourceCertificateRequestData;
import net.ripe.rpki.commons.ta.domain.request.RevocationRequest;
import net.ripe.rpki.commons.ta.domain.request.SigningRequest;
import net.ripe.rpki.commons.ta.domain.request.TaRequest;
import net.ripe.rpki.commons.ta.domain.request.TrustAnchorRequest;
import net.ripe.rpki.commons.util.XML;
import net.ripe.rpki.commons.xml.DomXmlSerializer;
import net.ripe.rpki.commons.xml.DomXmlSerializerException;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TrustAnchorRequestSerializer
extends DomXmlSerializer<TrustAnchorRequest> {
    private static final Base64.Decoder BASE64_DECODER = Base64.getMimeDecoder();
    private static final Base64.Encoder BASE64_ENCODER = Base64.getMimeEncoder();
    public static final String REQUESTS_TRUST_ANCHOR_REQUEST = "requests.TrustAnchorRequest";
    public static final String CREATION_TIMESTAMP = "creationTimestamp";
    public static final String TA_CERTIFICATE_PUBLICATION_URI = "taCertificatePublicationUri";
    public static final String TA_REQUESTS = "taRequests";
    public static final String SIA_DESCRIPTORS = "siaDescriptors";
    public static final String X_509_CERTIFICATE_INFORMATION_ACCESS_DESCRIPTOR = "X509CertificateInformationAccessDescriptor";
    public static final String METHOD = "method";
    public static final String LOCATION = "location";
    public static final String REQUESTS_REVOCATION_REQUEST = "requests.RevocationRequest";
    public static final String RESOURCE_CLASS_NAME = "resourceClassName";
    public static final String ENCODED_REVOCATION_PUBLIC_KEY = "encodedPublicKey";
    public static final String REQUEST_ID = "requestId";
    public static final String REQUESTS_SIGNING_REQUEST = "requests.SigningRequest";
    public static final String RESOURCE_CERTIFICATE_REQUEST = "resourceCertificateRequest";
    public static final String SUBJECT_DN = "subjectDN";
    public static final String ENCODED_SIGNING_SUBJECT_PUBLIC_KEY = "encodedSubjectPublicKey";
    public static final String SUBJECT_INFORMATION_ACCESS = "subjectInformationAccess";

    public TrustAnchorRequestSerializer() {
        super("");
    }

    @Override
    public String serialize(TrustAnchorRequest trustAnchorRequest) {
        if (trustAnchorRequest == null) {
            return null;
        }
        try {
            X509CertificateInformationAccessDescriptor[] descriptors;
            List<TaRequest> taRequests;
            Long creationTimestamp;
            Document doc = XML.newSecureDocumentBuilder().newDocument();
            Element requestsTrustAnchorRequestElement = this.addChild(doc, doc, REQUESTS_TRUST_ANCHOR_REQUEST);
            URI taCertificatePublicationUri = trustAnchorRequest.getTaCertificatePublicationUri();
            if (taCertificatePublicationUri != null) {
                this.addChild(doc, requestsTrustAnchorRequestElement, TA_CERTIFICATE_PUBLICATION_URI).setTextContent(taCertificatePublicationUri.toString());
            }
            if ((creationTimestamp = trustAnchorRequest.getCreationTimestamp()) != null) {
                this.addChild(doc, requestsTrustAnchorRequestElement, CREATION_TIMESTAMP).setTextContent(creationTimestamp.toString());
            }
            if ((taRequests = trustAnchorRequest.getTaRequests()) != null) {
                Element taRequestsElement = this.addChild(doc, requestsTrustAnchorRequestElement, TA_REQUESTS);
                for (TaRequest taRequest : taRequests) {
                    if (taRequest instanceof SigningRequest) {
                        Element signingRequestElement = this.addChild(doc, taRequestsElement, REQUESTS_SIGNING_REQUEST);
                        this.serializeSigningRequest(doc, signingRequestElement, (SigningRequest)taRequest);
                        continue;
                    }
                    if (!(taRequest instanceof RevocationRequest)) continue;
                    Element revocationRequestElement = this.addChild(doc, taRequestsElement, REQUESTS_REVOCATION_REQUEST);
                    this.serializeRevocationRequest(doc, revocationRequestElement, (RevocationRequest)taRequest);
                }
            }
            if ((descriptors = trustAnchorRequest.getSiaDescriptors()) != null) {
                Element siaDescriptors = this.addChild(doc, requestsTrustAnchorRequestElement, SIA_DESCRIPTORS);
                for (X509CertificateInformationAccessDescriptor informationAccessDescriptor : descriptors) {
                    this.serializeSia(doc, siaDescriptors, informationAccessDescriptor);
                }
            }
            return this.serialize(doc);
        }
        catch (ParserConfigurationException | TransformerException e) {
            throw new DomXmlSerializerException(e);
        }
    }

    private void serializeRevocationRequest(Document doc, Element revocationRequestElement, RevocationRequest revocationRequest) {
        this.addChild(doc, revocationRequestElement, REQUEST_ID).setTextContent(revocationRequest.getRequestId().toString());
        this.addChild(doc, revocationRequestElement, RESOURCE_CLASS_NAME).setTextContent(revocationRequest.getResourceClassName());
        this.addChild(doc, revocationRequestElement, ENCODED_REVOCATION_PUBLIC_KEY).setTextContent(revocationRequest.getEncodedPublicKey());
    }

    private void serializeSigningRequest(Document doc, Element signingRequestElement, SigningRequest signingRequest) {
        this.addChild(doc, signingRequestElement, REQUEST_ID).setTextContent(signingRequest.getRequestId().toString());
        Element resourceCertificateRequestElement = this.addChild(doc, signingRequestElement, RESOURCE_CERTIFICATE_REQUEST);
        this.addChild(doc, resourceCertificateRequestElement, RESOURCE_CLASS_NAME).setTextContent(signingRequest.getResourceCertificateRequest().getResourceClassName());
        this.addChild(doc, resourceCertificateRequestElement, SUBJECT_DN).setTextContent(signingRequest.getResourceCertificateRequest().getSubjectDN().getName());
        this.addChild(doc, resourceCertificateRequestElement, ENCODED_SIGNING_SUBJECT_PUBLIC_KEY).setTextContent(BASE64_ENCODER.encodeToString(signingRequest.getResourceCertificateRequest().getEncodedSubjectPublicKey()));
        Element subjectInformationAccessElement = this.addChild(doc, resourceCertificateRequestElement, SUBJECT_INFORMATION_ACCESS);
        for (X509CertificateInformationAccessDescriptor informationAccessDescriptor : signingRequest.getResourceCertificateRequest().getSubjectInformationAccess()) {
            this.serializeSia(doc, subjectInformationAccessElement, informationAccessDescriptor);
        }
    }

    private void serializeSia(Document doc, Element subjectInformationAccessElement, X509CertificateInformationAccessDescriptor informationAccessDescriptor) {
        Element x509CertificateInformationAccessDescriptorElement = this.addChild(doc, subjectInformationAccessElement, X_509_CERTIFICATE_INFORMATION_ACCESS_DESCRIPTOR);
        this.addChild(doc, x509CertificateInformationAccessDescriptorElement, METHOD).setTextContent(informationAccessDescriptor.getMethod().toString());
        this.addChild(doc, x509CertificateInformationAccessDescriptorElement, LOCATION).setTextContent(informationAccessDescriptor.getLocation().toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TrustAnchorRequest deserialize(String xml) {
        try (StringReader characterStream = new StringReader(xml);){
            Long creationTimeStamp;
            Document doc = XML.newSecureDocumentBuilder().parse(new InputSource(characterStream));
            Element taRequestElement = this.getElementWithPossibleLegacyName(doc, REQUESTS_TRUST_ANCHOR_REQUEST).orElseThrow(() -> new DomXmlSerializerException("requests.TrustAnchorRequest element not found"));
            Element creationTimestampElement = this.getSingleChildElement(taRequestElement, CREATION_TIMESTAMP);
            String creationTimeStampText = this.getElementTextContent(creationTimestampElement);
            try {
                creationTimeStamp = Long.parseLong(creationTimeStampText);
            }
            catch (NumberFormatException e) {
                throw new DomXmlSerializerException("creationTimestamp content is not a number: " + creationTimeStampText, e);
            }
            Optional<Element> taCertificatePublicationUriElement = this.getOptionalSingleChildElement(taRequestElement, TA_CERTIFICATE_PUBLICATION_URI);
            URI taCertificatePublicationUri = taCertificatePublicationUriElement.map(uri -> URI.create(this.getElementTextContent((Element)taCertificatePublicationUriElement.get()))).orElse(null);
            Element requestsListElement = this.getSingleChildElement(taRequestElement, TA_REQUESTS);
            List<TaRequest> taRequests = this.getTaSigningRequests(requestsListElement);
            taRequests.addAll(this.getTaRevocationRequests(requestsListElement));
            Element siaDescriptorsElement = this.getSingleChildElement(taRequestElement, SIA_DESCRIPTORS);
            X509CertificateInformationAccessDescriptor[] x509CertificateInformationAccessDescriptors = this.getX509CertificateInformationAccessDescriptorArray(siaDescriptorsElement);
            TrustAnchorRequest trustAnchorRequest = new TrustAnchorRequest(taCertificatePublicationUri, x509CertificateInformationAccessDescriptors, taRequests);
            this.setField(TrustAnchorRequest.class, trustAnchorRequest, CREATION_TIMESTAMP, creationTimeStamp);
            TrustAnchorRequest trustAnchorRequest2 = trustAnchorRequest;
            return trustAnchorRequest2;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new DomXmlSerializerException(e);
        }
    }

    private X509CertificateInformationAccessDescriptor[] getX509CertificateInformationAccessDescriptorArray(Element parent) {
        List<Element> x509CertificateInformationAccessDescriptorElements = this.getChildElements(parent, X_509_CERTIFICATE_INFORMATION_ACCESS_DESCRIPTOR);
        X509CertificateInformationAccessDescriptor[] x509CertificateInformationAccessDescriptors = new X509CertificateInformationAccessDescriptor[x509CertificateInformationAccessDescriptorElements.size()];
        int i = 0;
        for (Element x509CertificateInformationAccessElement : x509CertificateInformationAccessDescriptorElements) {
            Element methodElement = this.getSingleChildElement(x509CertificateInformationAccessElement, METHOD);
            String method = this.getElementTextContent(methodElement);
            Element locationElement = this.getSingleChildElement(x509CertificateInformationAccessElement, LOCATION);
            String location = this.getElementTextContent(locationElement);
            x509CertificateInformationAccessDescriptors[i] = new X509CertificateInformationAccessDescriptor(new ASN1ObjectIdentifier(method), URI.create(location));
            ++i;
        }
        return x509CertificateInformationAccessDescriptors;
    }

    private List<TaRequest> getTaRevocationRequests(Element taRequestElement) {
        ArrayList<TaRequest> taRequests = new ArrayList<TaRequest>();
        List<Element> revocationRequestElements = this.getChildElementsWithPossibleLegacyName(taRequestElement, REQUESTS_REVOCATION_REQUEST);
        for (Element revocationRequestElement : revocationRequestElements) {
            Element resourceClassNameElement = this.getSingleChildElement(revocationRequestElement, RESOURCE_CLASS_NAME);
            String resourceClassName = this.getElementTextContent(resourceClassNameElement);
            Element encodedSubjectPublicKeyElement = this.getSingleChildElement(revocationRequestElement, ENCODED_REVOCATION_PUBLIC_KEY);
            String encodedPublicKey = this.getElementTextContent(encodedSubjectPublicKeyElement);
            RevocationRequest taRequest = new RevocationRequest(resourceClassName, encodedPublicKey);
            Element requestIdElement = this.getSingleChildElement(revocationRequestElement, REQUEST_ID);
            String requestId = this.getElementTextContent(requestIdElement);
            this.setField(TaRequest.class, taRequest, REQUEST_ID, UUID.fromString(requestId));
            taRequests.add(taRequest);
        }
        return taRequests;
    }

    private List<TaRequest> getTaSigningRequests(Element taRequestElement) {
        ArrayList<TaRequest> taRequests = new ArrayList<TaRequest>();
        List<Element> signingRequestElements = this.getChildElementsWithPossibleLegacyName(taRequestElement, REQUESTS_SIGNING_REQUEST);
        for (Element signingRequestElement : signingRequestElements) {
            Element resourceCertificateRequestElement = this.getSingleChildElement(signingRequestElement, RESOURCE_CERTIFICATE_REQUEST);
            Element resourceClassNameElement = this.getSingleChildElement(resourceCertificateRequestElement, RESOURCE_CLASS_NAME);
            String resourceClassName = this.getElementTextContent(resourceClassNameElement);
            Element subjectDNElement = this.getSingleChildElement(resourceCertificateRequestElement, SUBJECT_DN);
            X500Principal subjectDN = new X500Principal(this.getElementTextContent(subjectDNElement));
            Element encodedSubjectPublicKeyElement = this.getSingleChildElement(resourceCertificateRequestElement, ENCODED_SIGNING_SUBJECT_PUBLIC_KEY);
            byte[] subjectPublicKey = BASE64_DECODER.decode(this.getElementTextContent(encodedSubjectPublicKeyElement));
            Element subjectInformationAccessElement = this.getSingleChildElement(resourceCertificateRequestElement, SUBJECT_INFORMATION_ACCESS);
            X509CertificateInformationAccessDescriptor[] x509CertificateInformationAccessDescriptors = this.getX509CertificateInformationAccessDescriptorArray(subjectInformationAccessElement);
            SigningRequest taRequest = new SigningRequest(ResourceCertificateRequestData.forTASigningRequest(resourceClassName, subjectDN, subjectPublicKey, x509CertificateInformationAccessDescriptors));
            Element requestIdElement = this.getSingleChildElement(signingRequestElement, REQUEST_ID);
            String requestId = this.getElementTextContent(requestIdElement);
            this.setField(TaRequest.class, taRequest, REQUEST_ID, UUID.fromString(requestId));
            taRequests.add(taRequest);
        }
        return taRequests;
    }

    private void setField(Class<?> clazz, Object obj, String fieldName, Object value) {
        try {
            Field privateField = clazz.getDeclaredField(fieldName);
            privateField.setAccessible(true);
            privateField.set(obj, value);
            privateField.setAccessible(false);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new DomXmlSerializerException("Unable to inject " + fieldName + ": " + value + " into " + obj.getClass().getSimpleName(), e);
        }
    }

    protected List<Element> getChildElementsWithPossibleLegacyName(Element parent, String tagName) {
        List<Element> childElements = this.getChildElements(parent, tagName);
        if (!childElements.isEmpty()) {
            return childElements;
        }
        return this.getChildElements(parent, "net.ripe.rpki.offline." + tagName);
    }

    private Optional<Element> getElementWithPossibleLegacyName(Document doc, String elementName) {
        Optional<Element> element = this.getElement(doc, elementName);
        if (element.isPresent()) {
            return element;
        }
        return this.getElement(doc, "net.ripe.rpki.offline." + elementName);
    }
}

