/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.ParserConfigurationException;
import net.ripe.rpki.commons.util.XML;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLTest {
    public static final String INTERNAL_ENTITY_TEST = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE foo [<!ENTITY toreplace \"3\"> ]>\n<stockCheck>\n    <productId>&toreplace;</productId>\n    <storeId>1</storeId>\n</stockCheck>";
    public static final String EXTERNAL_ENTITY_TEST = "<!--?xml version=\"1.0\" ?-->\n<!DOCTYPE foo [<!ENTITY example SYSTEM \"/etc/passwd\"> ]>\n<data>&example;</data>";

    private static InputStream inputStreamFrom(String s) {
        return new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8));
    }

    @Test
    public void doesNotResolveInternalEntities() throws ParserConfigurationException, IOException, SAXException {
        Assert.assertThrows(SAXParseException.class, () -> XML.newSecureDocumentBuilder().parse(XMLTest.inputStreamFrom(INTERNAL_ENTITY_TEST)));
    }

    @Test
    public void doesNotResolveExternalEntities() {
        Assert.assertThrows(SAXParseException.class, () -> XML.newSecureDocumentBuilder().parse(XMLTest.inputStreamFrom(EXTERNAL_ENTITY_TEST)));
    }
}

