/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.payload.error;

import java.io.IOException;
import java.util.regex.Pattern;
import net.ripe.rpki.commons.provisioning.payload.RelaxNgSchemaValidator;
import net.ripe.rpki.commons.provisioning.payload.error.NotPerformedError;
import net.ripe.rpki.commons.provisioning.payload.error.RequestNotPerformedResponsePayload;
import net.ripe.rpki.commons.provisioning.payload.error.RequestNotPerformedResponsePayloadBuilder;
import net.ripe.rpki.commons.provisioning.payload.error.RequestNotPerformedResponsePayloadSerializer;
import net.ripe.rpki.commons.xml.XmlSerializer;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

public class RequestNotPerformedResponsePayloadSerializerTest {
    private static final String TEST_ERROR_DESCRIPTION = "Something went wrong";
    private static final NotPerformedError TEST_ERROR = NotPerformedError.INTERNAL_SERVER_ERROR;
    private static final XmlSerializer<RequestNotPerformedResponsePayload> SERIALIZER = new RequestNotPerformedResponsePayloadSerializer();
    public static RequestNotPerformedResponsePayload NOT_PERFORMED_PAYLOAD = RequestNotPerformedResponsePayloadSerializerTest.createRequestNotPerformedResponsePayload();

    public static RequestNotPerformedResponsePayload createRequestNotPerformedResponsePayload() {
        RequestNotPerformedResponsePayloadBuilder builder = new RequestNotPerformedResponsePayloadBuilder();
        builder.withError(TEST_ERROR);
        builder.withDescription(TEST_ERROR_DESCRIPTION);
        return builder.build();
    }

    @Test
    public void shouldBuildValidListResponsePayload() throws Exception {
        Assert.assertEquals((Object)"sender", (Object)NOT_PERFORMED_PAYLOAD.getSender());
        Assert.assertEquals((Object)"recipient", (Object)NOT_PERFORMED_PAYLOAD.getRecipient());
        Assert.assertEquals((Object)TEST_ERROR, (Object)NOT_PERFORMED_PAYLOAD.getStatus());
        Assert.assertEquals((Object)TEST_ERROR_DESCRIPTION, (Object)NOT_PERFORMED_PAYLOAD.getDescription());
    }

    @Test
    public void shouldProduceXmlConformDraft() {
        String actualXml = SERIALIZER.serialize((Object)NOT_PERFORMED_PAYLOAD);
        Pattern expectedXml = Pattern.compile("<\\?xml version=\"1.0\" encoding=\"UTF-8\"\\?>\n<message\\s+xmlns=\"http://www.apnic.net/specs/rescerts/up-down/\"\\s+recipient=\"recipient\"\\s+sender=\"sender\"\\s+type=\"error_response\"\\s+version=\"1\">\n   <status>" + TEST_ERROR.getErrorCode() + "</status>\n   <description xml:lang=\"en-US\">" + TEST_ERROR_DESCRIPTION + "</description>\n</message>\n", 32);
        Assert.assertTrue((String)("actual xml: " + actualXml), (boolean)expectedXml.matcher(actualXml).matches());
    }

    @Test
    public void shouldDeserializeXml() {
        String actualXml = SERIALIZER.serialize((Object)NOT_PERFORMED_PAYLOAD);
        RequestNotPerformedResponsePayload deserialized = (RequestNotPerformedResponsePayload)SERIALIZER.deserialize(actualXml);
        Assert.assertEquals((Object)NOT_PERFORMED_PAYLOAD, (Object)deserialized);
    }

    @Test
    public void shouldProduceSchemaValidatedXml() throws SAXException, IOException {
        String actualXml = SERIALIZER.serialize((Object)NOT_PERFORMED_PAYLOAD);
        Assert.assertTrue((boolean)RelaxNgSchemaValidator.validateAgainstRelaxNg(actualXml));
    }
}

