/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.crl;

import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CRLException;
import javax.security.auth.x500.X500Principal;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.crl.X509CrlBuilder;
import net.ripe.rpki.commons.crypto.util.KeyPairFactoryTest;
import net.ripe.rpki.commons.crypto.util.KeyPairUtil;
import net.ripe.rpki.commons.util.UTC;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class X509CrlBuilderTest {
    private static final PublicKey PUBLIC_KEY = KeyPairFactoryTest.TEST_KEY_PAIR.getPublic();
    private static final PrivateKey PRIVATE_KEY = KeyPairFactoryTest.TEST_KEY_PAIR.getPrivate();
    private static final DateTime THIS_UPDATE_TIME = new DateTime(2007, 2, 28, 2, 53, 23, 0, DateTimeZone.UTC);
    private static final DateTime NEXT_UPDATE_TIME = new DateTime(2007, 3, 1, 2, 53, 23, 0, DateTimeZone.UTC);
    private static final DateTime REVOCATION_TIME = new DateTime(2007, 2, 25, 19, 23, 44, 123, DateTimeZone.UTC);
    private X509CrlBuilder subject;
    private X509Crl emptyCrl;
    private X509Crl nonEmptyCrl;

    @Before
    public void setUp() {
        this.subject = new X509CrlBuilder();
        this.subject.withIssuerDN(new X500Principal("CN=ROOT"));
        this.subject.withThisUpdateTime(THIS_UPDATE_TIME);
        this.subject.withNextUpdateTime(NEXT_UPDATE_TIME);
        this.subject.withNumber(BigInteger.ONE);
        this.subject.withAuthorityKeyIdentifier(PUBLIC_KEY);
        this.subject.withSignatureProvider("SunRsaSign");
        this.emptyCrl = this.subject.build(PRIVATE_KEY);
        this.subject.addEntry(BigInteger.TEN, REVOCATION_TIME);
        this.nonEmptyCrl = this.subject.build(PRIVATE_KEY);
    }

    @Test
    public void shouldHaveVesion2() {
        Assert.assertEquals((long)2L, (long)this.emptyCrl.getVersion());
    }

    @Test
    public void shouldHaveIssuer() {
        Assert.assertEquals((Object)new X500Principal("CN=ROOT"), (Object)this.emptyCrl.getIssuer());
    }

    @Test
    public void shouldHaveUpdateTimes() {
        Assert.assertEquals((Object)THIS_UPDATE_TIME, (Object)new DateTime((Object)this.emptyCrl.getThisUpdateTime(), DateTimeZone.UTC));
        Assert.assertEquals((Object)NEXT_UPDATE_TIME, (Object)new DateTime((Object)this.emptyCrl.getNextUpdateTime(), DateTimeZone.UTC));
    }

    @Test
    public void shouldUseSha256WithRsaEncryption() {
        Assert.assertEquals((Object)"SHA256withRSA", (Object)this.emptyCrl.getSigAlgName());
    }

    @Test
    public void shouldHaveNonNullRevokedCertificatesWhenEmpty() {
        Assert.assertNotNull((Object)this.emptyCrl.getRevokedCertificates());
        Assert.assertEquals((long)0L, (long)this.emptyCrl.getRevokedCertificates().size());
    }

    @Test
    public void shouldHaveCrlEntryForRevokedCertificate() {
        X509Crl.Entry entry = this.nonEmptyCrl.getRevokedCertificate(BigInteger.TEN);
        Assert.assertEquals((Object)BigInteger.TEN, (Object)entry.getSerialNumber());
        Assert.assertEquals((Object)REVOCATION_TIME.withMillisOfSecond(0), (Object)entry.getRevocationDateTime());
    }

    @Test
    public void shouldHaveTwoCrlEntriesForTwoRevokedCertificates() {
        this.subject.addEntry(BigInteger.ONE, REVOCATION_TIME);
        X509Crl crl = this.subject.build(PRIVATE_KEY);
        Assert.assertEquals((long)2L, (long)crl.getRevokedCertificates().size());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldRejectDuplicateCrlEntriesForSameSerial() {
        this.subject.addEntry(BigInteger.TEN, REVOCATION_TIME);
    }

    @Test
    public void shouldHaveAuthorityKeyIdentiferExtension() {
        byte[] authorityKeyIdentifier = this.nonEmptyCrl.getAuthorityKeyIdentifier();
        Assert.assertNotNull((Object)authorityKeyIdentifier);
        Assert.assertArrayEquals((byte[])KeyPairUtil.getKeyIdentifier((PublicKey)PUBLIC_KEY), (byte[])authorityKeyIdentifier);
    }

    @Test
    public void shouldHaveCrlNumberExtension() throws IOException {
        Assert.assertEquals((Object)BigInteger.ONE, (Object)this.nonEmptyCrl.getNumber());
    }

    @Test
    public void shouldVerify() throws InvalidKeyException, CRLException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException {
        this.emptyCrl.verify(PUBLIC_KEY);
        this.nonEmptyCrl.verify(PUBLIC_KEY);
    }

    @Test(expected=SignatureException.class)
    public void shouldFailVerifyWithOtherKey() throws InvalidKeyException, CRLException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException {
        this.emptyCrl.verify(KeyPairFactoryTest.SECOND_TEST_KEY_PAIR.getPublic());
    }

    @Test
    public void shouldBeSatisfiedByCrlWithSameEntries() {
        Assert.assertTrue((boolean)this.subject.isSatisfiedByEntries(this.nonEmptyCrl));
    }

    @Test
    public void shouldBeSatifisfiedByCrlWithAdditionalEntries() {
        this.subject.clearEntries();
        Assert.assertTrue((boolean)this.subject.isSatisfiedByEntries(this.nonEmptyCrl));
    }

    @Test
    public void shouldNotBeSatisfiedByCrlWithFewerEntries() {
        this.subject.addEntry(BigInteger.valueOf(42L), UTC.dateTime());
        Assert.assertFalse((boolean)this.subject.isSatisfiedByEntries(this.nonEmptyCrl));
    }

    @Test
    public void shouldNotRejectReasonableCrlNumber() {
        this.subject.withNumber(BigInteger.valueOf(2L).pow(150));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldRejectNegativeBigCrlNumber() {
        this.subject.withNumber(BigInteger.valueOf(-10L));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldRejectVeryBigCrlNumber() {
        this.subject.withNumber(BigInteger.valueOf(2L).pow(160));
    }
}

