/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.payload.revocation.request;

import java.util.Collections;
import net.ripe.rpki.commons.provisioning.payload.AbstractProvisioningPayloadXmlSerializer;
import net.ripe.rpki.commons.provisioning.payload.PayloadMessageType;
import net.ripe.rpki.commons.provisioning.payload.revocation.CertificateRevocationKeyElement;
import net.ripe.rpki.commons.provisioning.payload.revocation.request.CertificateRevocationRequestPayload;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CertificateRevocationRequestPayloadSerializer
extends AbstractProvisioningPayloadXmlSerializer<CertificateRevocationRequestPayload> {
    public CertificateRevocationRequestPayloadSerializer() {
        super(PayloadMessageType.revoke);
    }

    @Override
    protected CertificateRevocationRequestPayload parseXmlPayload(Element message) {
        Element requestElement = this.getSingleChildElement(message, "key");
        String className = this.getRequiredAttributeValue(requestElement, "class_name");
        String ski = this.getRequiredAttributeValue(requestElement, "ski");
        return new CertificateRevocationRequestPayload(new CertificateRevocationKeyElement(className, ski));
    }

    @Override
    protected Iterable<? extends Node> generateXmlPayload(Document document, CertificateRevocationRequestPayload payload) {
        CertificateRevocationKeyElement key = payload.getKeyElement();
        Element keyElement = document.createElementNS(this.xmlns, "key");
        keyElement.setAttribute("class_name", key.getClassName());
        keyElement.setAttribute("ski", key.getPublicKeyHash());
        return Collections.singletonList(keyElement);
    }
}

