/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.identity;

import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.ripe.rpki.commons.provisioning.identity.IdentitySerializer;
import net.ripe.rpki.commons.provisioning.identity.ParentIdentity;
import net.ripe.rpki.commons.provisioning.x509.ProvisioningIdentityCertificate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ParentIdentitySerializer
extends IdentitySerializer<ParentIdentity> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ParentIdentity deserialize(String xml) {
        try (StringReader characterStream = new StringReader(xml);){
            Document doc = this.getDocumentBuilder().parse(new InputSource(characterStream));
            Element root = this.getElement(doc, "parent_response").orElseThrow(() -> new IdentitySerializer.IdentitySerializerException("parent_response element not found"));
            String childHandle = this.getRequiredAttributeValue(root, "child_handle");
            String parentHandle = this.getRequiredAttributeValue(root, "parent_handle");
            String serviceUri = this.getRequiredAttributeValue(root, "service_uri");
            String parentBpkiTa = this.getBpkiElementContent(doc, "parent_bpki_ta").orElseThrow(() -> new IdentitySerializer.IdentitySerializerException("parent_bpki_ta element not found"));
            ProvisioningIdentityCertificate provisioningIdentityCertificate = this.getProvisioningIdentityCertificate(parentBpkiTa);
            ParentIdentity parentIdentity = new ParentIdentity(URI.create(serviceUri), parentHandle, childHandle, provisioningIdentityCertificate);
            return parentIdentity;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new IdentitySerializer.IdentitySerializerException("Fail to parse parent response", e);
        }
    }

    @Override
    public String serialize(ParentIdentity parentIdentity) {
        try {
            Document document = this.getDocumentBuilder().newDocument();
            Element parentResponseElement = document.createElementNS("http://www.hactrn.net/uris/rpki/rpki-setup/", "parent_response");
            parentResponseElement.setAttribute("child_handle", parentIdentity.getChildHandle());
            parentResponseElement.setAttribute("parent_handle", parentIdentity.getParentHandle());
            parentResponseElement.setAttribute("service_uri", parentIdentity.getUpDownUrl().toString());
            parentResponseElement.setAttribute("version", Integer.toString(parentIdentity.getVersion()));
            Element parentBpkiTaElement = document.createElementNS("http://www.hactrn.net/uris/rpki/rpki-setup/", "parent_bpki_ta");
            parentBpkiTaElement.setTextContent(parentIdentity.getParentIdCertificate().getBase64String());
            parentResponseElement.appendChild(parentBpkiTaElement);
            document.appendChild(parentResponseElement);
            return this.serialize(document);
        }
        catch (ParserConfigurationException | TransformerException e) {
            throw new IdentitySerializer.IdentitySerializerException(e);
        }
    }
}

