/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.validation.objectvalidators;

import net.ripe.ipresource.IpResourceSet;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.validation.ValidationOptions;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import net.ripe.rpki.commons.validation.objectvalidators.X509ResourceCertificateParentChildLooseValidator;
import net.ripe.rpki.commons.validation.objectvalidators.X509ResourceCertificateParentChildValidator;
import net.ripe.rpki.commons.validation.objectvalidators.X509ResourceCertificateValidator;

public class ResourceValidatorFactory {
    public static X509ResourceCertificateParentChildValidator getX509ResourceCertificateStrictValidator(CertificateRepositoryObjectValidationContext context, ValidationOptions options, ValidationResult result, X509Crl crl) {
        return new X509ResourceCertificateParentChildValidator(options, result, context.getCertificate(), crl, context.getResources());
    }

    public static X509ResourceCertificateValidator getX509ResourceCertificateValidator(CertificateRepositoryObjectValidationContext context, ValidationOptions options, ValidationResult result, X509Crl crl) {
        if (options.isLooseValidationEnabled()) {
            return new X509ResourceCertificateParentChildLooseValidator(options, result, crl, context);
        }
        return new X509ResourceCertificateParentChildValidator(options, result, context.getCertificate(), crl, context.getResources());
    }

    public static X509ResourceCertificateParentChildValidator getX509ResourceCertificateParentChildStrictValidator(ValidationOptions options, ValidationResult result, X509ResourceCertificate parent, IpResourceSet resources, X509Crl crl) {
        return new X509ResourceCertificateParentChildValidator(options, result, parent, crl, resources);
    }
}

