/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.rsync;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.util.CertificateRepositoryObjectFactory;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.rsync.RemoteCertificateFetcherException;
import net.ripe.rpki.commons.rsync.Rsync;
import net.ripe.rpki.commons.util.ConfigurationUtil;
import net.ripe.rpki.commons.validation.ValidationResult;

public class RemoteCertificateFetcher {
    private Rsync rsync = new Rsync();

    public X509ResourceCertificate getRemoteResourceCertificate(String sourcePath) {
        try {
            return (X509ResourceCertificate)this.getRemoteObject(sourcePath);
        }
        catch (ClassCastException e) {
            throw new RemoteCertificateFetcherException("Remote object at: " + sourcePath + "is NOT a X509ResourceCertificate", e);
        }
    }

    public X509Crl getRemoteCrl(String sourcePath) {
        try {
            return (X509Crl)this.getRemoteObject(sourcePath);
        }
        catch (ClassCastException e) {
            throw new RemoteCertificateFetcherException("Remote object at: " + sourcePath + "is NOT a X509Crl", e);
        }
    }

    private CertificateRepositoryObject getRemoteObject(String sourcePath) {
        String tempDestinationPath = ConfigurationUtil.getTempDirectory() + "/rsync-tmp-" + UUID.randomUUID();
        File tempDestinationFile = new File(tempDestinationPath);
        try {
            if (!tempDestinationFile.exists()) {
                tempDestinationFile.getParentFile().mkdir();
            }
            this.rsync.reset();
            this.rsync.setSource(sourcePath);
            this.rsync.setDestination(tempDestinationPath);
            int rc = this.rsync.execute();
            if (rc == 0) {
                byte[] encoded = Files.toByteArray((File)tempDestinationFile);
                CertificateRepositoryObject certificateRepositoryObject = CertificateRepositoryObjectFactory.createCertificateRepositoryObject(encoded, ValidationResult.withLocation(sourcePath));
                return certificateRepositoryObject;
            }
            CertificateRepositoryObject certificateRepositoryObject = null;
            return certificateRepositoryObject;
        }
        catch (IOException e) {
            throw new RemoteCertificateFetcherException("I/O error occurred trying to rsync from: " + this.rsync.getSource() + " to:" + this.rsync.getDestination(), e);
        }
        catch (ClassCastException e) {
            throw new RemoteCertificateFetcherException("Remote object is not a resource certificate!", e);
        }
        finally {
            if (tempDestinationFile.exists()) {
                tempDestinationFile.delete();
            }
        }
    }

    void setRsyncClient(Rsync stubbedRsync) {
        this.rsync = stubbedRsync;
    }
}

