/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.util;

import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.UnknownCertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.cms.ghostbuster.GhostbustersCms;
import net.ripe.rpki.commons.crypto.cms.ghostbuster.GhostbustersCmsParser;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCms;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCmsParser;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCms;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCmsParser;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateParser;
import net.ripe.rpki.commons.util.RepositoryObjectType;
import net.ripe.rpki.commons.validation.ValidationChecks;
import net.ripe.rpki.commons.validation.ValidationResult;

public final class CertificateRepositoryObjectFactory {
    private CertificateRepositoryObjectFactory() {
    }

    public static CertificateRepositoryObject createCertificateRepositoryObject(byte[] encoded, ValidationResult validationResult) {
        RepositoryObjectType objectType = RepositoryObjectType.parse(validationResult.getCurrentLocation().getName());
        ValidationChecks.knownObjectType(objectType, validationResult);
        switch (objectType) {
            case Manifest: {
                return CertificateRepositoryObjectFactory.parseManifest(encoded, validationResult);
            }
            case Roa: {
                return CertificateRepositoryObjectFactory.parseRoa(encoded, validationResult);
            }
            case Certificate: {
                return CertificateRepositoryObjectFactory.parseX509ResourceCertificate(encoded, validationResult);
            }
            case Crl: {
                return CertificateRepositoryObjectFactory.parseCrl(encoded, validationResult);
            }
            case Gbr: {
                return CertificateRepositoryObjectFactory.parseGbr(encoded, validationResult);
            }
            case Unknown: {
                return new UnknownCertificateRepositoryObject(encoded);
            }
        }
        throw new IllegalArgumentException("Unrecognized repository object type");
    }

    private static X509Crl parseCrl(byte[] encoded, ValidationResult validationResult) {
        return X509Crl.parseDerEncoded(encoded, validationResult);
    }

    private static X509ResourceCertificate parseX509ResourceCertificate(byte[] encoded, ValidationResult validationResult) {
        X509ResourceCertificateParser parser = new X509ResourceCertificateParser();
        ValidationResult temp = ValidationResult.withLocation(validationResult.getCurrentLocation());
        parser.parse(temp, encoded);
        if (parser.isSuccess()) {
            validationResult.addAll(temp);
            return parser.getCertificate();
        }
        validationResult.addAll(temp);
        return null;
    }

    private static RoaCms parseRoa(byte[] encoded, ValidationResult validationResult) {
        RoaCmsParser parser = new RoaCmsParser();
        ValidationResult temp = ValidationResult.withLocation(validationResult.getCurrentLocation());
        parser.parse(temp, encoded);
        validationResult.addAll(temp);
        if (parser.isSuccess()) {
            return parser.getRoaCms();
        }
        return null;
    }

    private static ManifestCms parseManifest(byte[] encoded, ValidationResult validationResult) {
        ManifestCmsParser parser = new ManifestCmsParser();
        ValidationResult temp = ValidationResult.withLocation(validationResult.getCurrentLocation());
        parser.parse(temp, encoded);
        if (parser.isSuccess()) {
            validationResult.addAll(temp);
            return parser.getManifestCms();
        }
        validationResult.addAll(temp);
        return null;
    }

    private static GhostbustersCms parseGbr(byte[] encoded, ValidationResult validationResult) {
        GhostbustersCmsParser parser = new GhostbustersCmsParser();
        ValidationResult temp = ValidationResult.withLocation(validationResult.getCurrentLocation());
        parser.parse(temp, encoded);
        if (parser.isSuccess()) {
            validationResult.addAll(temp);
            return parser.getGhostbustersCms();
        }
        validationResult.addAll(temp);
        return null;
    }
}

