/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto;

import java.io.Serializable;
import java.util.Date;
import net.ripe.rpki.commons.util.EqualsSupport;
import org.apache.commons.lang.Validate;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

public class ValidityPeriod
extends EqualsSupport
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final DateTime notValidBefore;
    private final DateTime notValidAfter;

    public ValidityPeriod() {
        this((Date)null, (Date)null);
    }

    public ValidityPeriod(ReadableInstant notValidBefore, ReadableInstant notValidAfter) {
        this.notValidBefore = notValidBefore == null ? null : new DateTime(this.truncatedMillis(notValidBefore.getMillis()), DateTimeZone.UTC);
        this.notValidAfter = notValidAfter == null ? null : new DateTime(this.truncatedMillis(notValidAfter.getMillis()), DateTimeZone.UTC);
        Validate.isTrue((boolean)ValidityPeriod.isDateOrderingValid(this.notValidBefore, this.notValidAfter), (String)("Got an invalid validatity time from: " + notValidBefore + " to: " + notValidAfter));
    }

    public ValidityPeriod(Date notValidBefore, Date notValidAfter) {
        this.notValidBefore = notValidBefore == null ? null : new DateTime(this.truncatedMillis(notValidBefore.getTime()), DateTimeZone.UTC);
        this.notValidAfter = notValidAfter == null ? null : new DateTime(this.truncatedMillis(notValidAfter.getTime()), DateTimeZone.UTC);
        Validate.isTrue((boolean)ValidityPeriod.isDateOrderingValid(this.notValidBefore, this.notValidAfter), (String)("Got an invalid validatity time from: " + notValidBefore + " to: " + notValidAfter));
    }

    private static boolean isDateOrderingValid(DateTime notValidBefore, DateTime notValidAfter) {
        return notValidBefore == null || notValidAfter == null || notValidBefore.isEqual((ReadableInstant)notValidAfter) || notValidBefore.isBefore((ReadableInstant)notValidAfter);
    }

    private long truncatedMillis(long millisec) {
        return millisec / 1000L * 1000L;
    }

    public DateTime getNotValidAfter() {
        return this.notValidAfter;
    }

    public DateTime getNotValidBefore() {
        return this.notValidBefore;
    }

    public ValidityPeriod withNotValidBefore(ReadableInstant notValidBefore) {
        return new ValidityPeriod(notValidBefore, (ReadableInstant)this.getNotValidAfter());
    }

    public ValidityPeriod withNotValidAfter(ReadableInstant notValidAfter) {
        return new ValidityPeriod((ReadableInstant)this.getNotValidBefore(), notValidAfter);
    }

    public boolean contains(ValidityPeriod other) {
        return this.isValidAt((ReadableInstant)other.getNotValidBefore()) && this.isValidAt((ReadableInstant)other.getNotValidAfter());
    }

    public boolean isExpiredNow() {
        return this.isExpiredAt((ReadableInstant)new Instant());
    }

    public boolean isExpiredAt(ReadableInstant instant) {
        return this.notValidAfter != null && instant.isAfter((ReadableInstant)this.getNotValidAfter());
    }

    public boolean isValidNow() {
        return this.isValidAt((ReadableInstant)new Instant());
    }

    public boolean isValidAt(ReadableInstant instant) {
        if (instant == null) {
            return !this.isClosed();
        }
        return !(this.notValidBefore != null && instant.isBefore((ReadableInstant)this.getNotValidBefore()) || this.notValidAfter != null && instant.isAfter((ReadableInstant)this.getNotValidAfter()));
    }

    public boolean isClosed() {
        return this.notValidBefore != null && this.notValidAfter != null;
    }

    public ValidityPeriod intersectedWith(ValidityPeriod other) {
        DateTime earliestNotValidAfter;
        DateTime latestNotValidBefore = this.latestDateTimeOf(this.notValidBefore, other.notValidBefore);
        if (ValidityPeriod.isDateOrderingValid(latestNotValidBefore, earliestNotValidAfter = this.earliestDateTimeOf(this.notValidAfter, other.notValidAfter))) {
            return new ValidityPeriod((ReadableInstant)latestNotValidBefore, (ReadableInstant)earliestNotValidAfter);
        }
        return null;
    }

    private DateTime earliestDateTimeOf(DateTime date1, DateTime date2) {
        if (date1 == null) {
            return date2;
        }
        if (date2 == null) {
            return date1;
        }
        return date1.isBefore((ReadableInstant)date2) ? date1 : date2;
    }

    private DateTime latestDateTimeOf(DateTime date1, DateTime date2) {
        if (date1 == null) {
            return date2;
        }
        if (date2 == null) {
            return date1;
        }
        return date1.isAfter((ReadableInstant)date2) ? date1 : date2;
    }

    @Override
    public String toString() {
        return this.getNotValidBefore() + " - " + this.getNotValidAfter();
    }
}

