/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.validation;

import com.gargoylesoftware.base.testing.EqualsTester;
import java.net.URI;
import java.util.EnumSet;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.ipresource.IpResourceType;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateTest;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CertificateRepositoryObjectValidationContextTest {
    private static final IpResourceSet CHILD_RESOURCE_SET = IpResourceSet.parse((String)"10.8.0.0/16");
    private static URI location = URI.create("rsync://host/path");
    private static X509ResourceCertificate certificate = X509ResourceCertificateTest.createSelfSignedCaResourceCertificate();
    private static URI childLocation = URI.create("rsync://host/path/child");
    private CertificateRepositoryObjectValidationContext subject = CertificateRepositoryObjectValidationContextTest.create();
    private X509ResourceCertificate certificateWithInheritedResources;

    public static CertificateRepositoryObjectValidationContext create() {
        return new CertificateRepositoryObjectValidationContext(location, certificate);
    }

    @Before
    public void setUp() {
        this.certificateWithInheritedResources = X509ResourceCertificateTest.createSelfSignedCaResourceCertificateBuilder().withInheritedResourceTypes(EnumSet.allOf(IpResourceType.class)).withResources(new IpResourceSet()).build();
    }

    @Test
    public void shouldContainLocationAndCertificateAndResources() {
        Assert.assertSame((Object)location, (Object)this.subject.getLocation());
        Assert.assertSame((Object)certificate, (Object)this.subject.getCertificate());
        Assert.assertEquals((Object)certificate.getResources(), (Object)this.subject.getResources());
    }

    @Test
    public void shouldUpdateResourcesForChildCertificateWithoutInheritedResources() {
        X509ResourceCertificate childCertificate = X509ResourceCertificateTest.createSelfSignedCaResourceCertificate(CHILD_RESOURCE_SET);
        CertificateRepositoryObjectValidationContext childContext = this.subject.createChildContext(childLocation, childCertificate);
        Assert.assertEquals((Object)CHILD_RESOURCE_SET, (Object)childContext.getResources());
    }

    @Test
    public void shouldNotUpdateResourcesForChildCertificateWithInheritedResources() {
        CertificateRepositoryObjectValidationContext childContext = this.subject.createChildContext(childLocation, this.certificateWithInheritedResources);
        Assert.assertEquals((Object)this.subject.getResources(), (Object)childContext.getResources());
    }

    @Test
    public void shouldUpdateLocationAndCertificateForChildCertificate() {
        CertificateRepositoryObjectValidationContext childContext = this.subject.createChildContext(childLocation, this.certificateWithInheritedResources);
        Assert.assertSame((Object)childLocation, (Object)childContext.getLocation());
        Assert.assertSame((Object)this.certificateWithInheritedResources, (Object)childContext.getCertificate());
    }

    @Test
    public void shouldUpdateSubjectChainForChildCertificate() {
        CertificateRepositoryObjectValidationContext childContext = this.subject.createChildContext(childLocation, this.certificateWithInheritedResources);
        Assert.assertEquals((long)(this.subject.getSubjectChain().size() + 1), (long)childContext.getSubjectChain().size());
        Assert.assertEquals((Object)this.certificateWithInheritedResources.getSubject().getName(), childContext.getSubjectChain().get(childContext.getSubjectChain().size() - 1));
    }

    @Test
    public void testEquals() {
        CertificateRepositoryObjectValidationContext a = new CertificateRepositoryObjectValidationContext(location, certificate);
        CertificateRepositoryObjectValidationContext b = new CertificateRepositoryObjectValidationContext(location, certificate);
        CertificateRepositoryObjectValidationContext c = new CertificateRepositoryObjectValidationContext(URI.create("rsync://another/uri"), this.certificateWithInheritedResources);
        CertificateRepositoryObjectValidationContext d = new CertificateRepositoryObjectValidationContext(location, certificate){};
        new EqualsTester((Object)a, (Object)b, (Object)c, (Object)d);
    }
}

