/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms.manifest;

import java.math.BigInteger;
import java.net.URI;
import java.util.EnumSet;
import javax.security.auth.x500.X500Principal;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.ipresource.IpResourceType;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.crypto.util.KeyPairFactoryTest;
import net.ripe.rpki.commons.crypto.x509cert.RpkiSignedObjectEeCertificateBuilder;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateTest;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RpkiSignedObjectEeCertificateBuilderTest {
    public static final int KEY_SIZE = 2048;
    public static final String DEFAULT_SIGNATURE_PROVIDER = "SunRsaSign";
    private RpkiSignedObjectEeCertificateBuilder subject;

    @Before
    public void setUp() {
        this.subject = new RpkiSignedObjectEeCertificateBuilder();
    }

    @Test
    public void shouldCreateEeCertificate() {
        X509ResourceCertificate resourceCertificate = X509ResourceCertificateTest.createSelfSignedCaResourceCertificate();
        URI crlUri = URI.create("rsync://somewhere/certificate.crl");
        this.subject.withCrlUri(crlUri);
        URI manifestUri = URI.create("rsync://somewhere/certificate.mft");
        this.subject.withCorrespondingCmsPublicationPoint(manifestUri);
        this.subject.withSigningKeyPair(KeyPairFactoryTest.TEST_KEY_PAIR);
        this.subject.withPublicKey(KeyPairFactoryTest.SECOND_TEST_KEY_PAIR.getPublic());
        DateTime now = new DateTime();
        ValidityPeriod vp = new ValidityPeriod((ReadableInstant)now, (ReadableInstant)now.plusSeconds(5));
        this.subject.withValidityPeriod(vp);
        URI publicationUri = URI.create("rsync://somewhere/certificate.cer");
        this.subject.withParentResourceCertificatePublicationUri(publicationUri);
        this.subject.withSerial(BigInteger.TEN);
        this.subject.withSubjectDN(new X500Principal("CN=subject"));
        this.subject.withIssuerDN(resourceCertificate.getSubject());
        this.subject.withSignatureProvider(DEFAULT_SIGNATURE_PROVIDER);
        this.subject.withResources(new IpResourceSet());
        this.subject.withInheritedResourceTypes(EnumSet.allOf(IpResourceType.class));
        X509ResourceCertificate certificate = this.subject.build();
        Assert.assertEquals((Object)BigInteger.TEN, (Object)certificate.getSerialNumber());
        Assert.assertEquals((Object)resourceCertificate.getSubject(), (Object)certificate.getIssuer());
        Assert.assertEquals((Object)crlUri, (Object)certificate.getCrlUri());
        Assert.assertEquals((Object)manifestUri, (Object)certificate.getSubjectInformationAccess()[0].getLocation());
        Assert.assertEquals((Object)publicationUri, (Object)certificate.getAuthorityInformationAccess()[0].getLocation());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotBuildWithoutSerialNumber() {
        this.createValidEeBuilder();
        this.subject.withSerial(null);
        this.buildOrFail();
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotBuildWithoutResourceCertificatePublicationUri() {
        this.createValidEeBuilder();
        this.subject.withParentResourceCertificatePublicationUri(null);
        this.buildOrFail();
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotBuildWithoutValidityPeriod() {
        this.createValidEeBuilder();
        this.subject.withValidityPeriod(null);
        this.buildOrFail();
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotBuildWithoutIssuer() {
        this.createValidEeBuilder();
        this.subject.withIssuerDN(null);
        this.buildOrFail();
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotBuildWithoutSigningKeyPair() {
        this.createValidEeBuilder();
        this.subject.withSigningKeyPair(null);
        this.buildOrFail();
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotBuildWithoutManifestUri() {
        this.createValidEeBuilder();
        this.subject.withCorrespondingCmsPublicationPoint(null);
        this.buildOrFail();
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotBuildWithoutCrlPublicationUri() {
        this.createValidEeBuilder();
        this.subject.withCrlUri(null);
        this.buildOrFail();
    }

    private void buildOrFail() {
        this.subject.build();
        Assert.fail((String)"Should have thrown");
    }

    private void createValidEeBuilder() {
        X509ResourceCertificate resourceCertificate = X509ResourceCertificateTest.createSelfSignedCaResourceCertificate();
        URI crlUri = URI.create("rsync://somewhere/certificate.crl");
        this.subject.withCrlUri(crlUri);
        URI manifestUri = URI.create("rsync://somewhere/certificate.mft");
        this.subject.withCorrespondingCmsPublicationPoint(manifestUri);
        this.subject.withSigningKeyPair(KeyPairFactoryTest.TEST_KEY_PAIR);
        this.subject.withIssuerDN(resourceCertificate.getSubject());
        DateTime now = new DateTime();
        this.subject.withValidityPeriod(new ValidityPeriod((ReadableInstant)now, (ReadableInstant)now.plusSeconds(5)));
        URI publicationUri = URI.create("rsync://somewhere/certificate.cer");
        this.subject.withParentResourceCertificatePublicationUri(publicationUri);
        this.subject.withSerial(BigInteger.TEN);
    }
}

