/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms.ghostbuster;

import java.io.File;
import net.ripe.rpki.commons.crypto.cms.ghostbuster.GhostbustersCmsParser;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Test;

public class GhostbustersCmsParserTest {
    @Test
    public void testShouldParseGoodGbr() throws Exception {
        String path = "src/test/resources/conformance/root/goodRealGbrNothingIsWrong.gbr";
        byte[] bytes = FileUtils.readFileToByteArray((File)new File(path));
        GhostbustersCmsParser parser = new GhostbustersCmsParser();
        parser.parse(ValidationResult.withLocation((String)"test1.gbr"), bytes);
        String vCard = parser.getGhostbustersCms().getvCard();
        Assert.assertEquals((Object)"BEGIN:VCARD\r\nVERSION:3.0\r\nADR:;;5147 Crystal Springs Drive NE;Bainbridge Island;Washington;98110;Uni\r\n ted States\r\nEMAIL:randy@psg.com\r\nFN:Randy Bush\r\nN:;;;;\r\nORG:RGnet\\, LLC\r\nTEL:+1 206 356 8341\r\nEND:VCARD\r\n", (Object)vCard);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testShouldParseBadGbr() throws Exception {
        String path = "src/test/resources/conformance/root/badGBRNotVCard.gbr";
        byte[] bytes = FileUtils.readFileToByteArray((File)new File(path));
        GhostbustersCmsParser parser = new GhostbustersCmsParser();
        parser.parse(ValidationResult.withLocation((String)"test2.gbr"), bytes);
        parser.getGhostbustersCms().getvCard();
    }
}

