/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.payload.common;

import java.net.URI;
import java.util.List;
import net.ripe.ipresource.IpResource;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.ipresource.IpResourceType;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.util.EqualsSupport;

public class CertificateElement
extends EqualsSupport {
    private List<URI> issuerCertificatePublicationLocationUris;
    private IpResourceSet allocatedAsn;
    private IpResourceSet allocatedIpv4;
    private IpResourceSet allocatedIpv6;
    private X509ResourceCertificate certificate;

    public CertificateElement setIssuerCertificatePublicationLocation(List<URI> issuerCertificatePublicationLocation) {
        this.issuerCertificatePublicationLocationUris = issuerCertificatePublicationLocation;
        return this;
    }

    public CertificateElement setCertificate(X509ResourceCertificate certificate) {
        this.certificate = certificate;
        return this;
    }

    public CertificateElement setIpResourceSet(IpResourceSet ipResourceSet) {
        this.allocatedAsn = new IpResourceSet();
        this.allocatedIpv4 = new IpResourceSet();
        this.allocatedIpv6 = new IpResourceSet();
        for (IpResource resource : ipResourceSet) {
            if (resource.getType().equals((Object)IpResourceType.ASN)) {
                this.allocatedAsn.add(resource);
                continue;
            }
            if (resource.getType().equals((Object)IpResourceType.IPv4)) {
                this.allocatedIpv4.add(resource);
                continue;
            }
            if (!resource.getType().equals((Object)IpResourceType.IPv6)) continue;
            this.allocatedIpv6.add(resource);
        }
        return this;
    }

    public List<URI> getIssuerCertificatePublicationUris() {
        return this.issuerCertificatePublicationLocationUris;
    }

    public URI getRsyncAIAPointer() {
        for (URI uri : this.issuerCertificatePublicationLocationUris) {
            if (!"rsync".equalsIgnoreCase(uri.getScheme())) continue;
            return uri;
        }
        return null;
    }

    public IpResourceSet getAllocatedAsn() {
        return this.allocatedAsn;
    }

    public IpResourceSet getAllocatedIpv4() {
        return this.allocatedIpv4;
    }

    public IpResourceSet getAllocatedIpv6() {
        return this.allocatedIpv6;
    }

    public X509ResourceCertificate getCertificate() {
        return this.certificate;
    }

    public void setAllocatedAsn(IpResourceSet allocatedAsn) {
        this.allocatedAsn = allocatedAsn;
    }

    public void setAllocatedIpv4(IpResourceSet allocatedIpv4) {
        this.allocatedIpv4 = allocatedIpv4;
    }

    public void setAllocatedIpv6(IpResourceSet allocatedIpv6) {
        this.allocatedIpv6 = allocatedIpv6;
    }
}

