/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.identity;

import java.util.Base64;
import java.util.Optional;
import net.ripe.rpki.commons.provisioning.x509.ProvisioningIdentityCertificate;
import net.ripe.rpki.commons.provisioning.x509.ProvisioningIdentityCertificateParser;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.xml.DomXmlSerializer;
import net.ripe.rpki.commons.xml.DomXmlSerializerException;
import org.w3c.dom.Document;

public abstract class IdentitySerializer<T>
extends DomXmlSerializer<T> {
    public static final String XMLNS = "http://www.hactrn.net/uris/rpki/rpki-setup/";

    public IdentitySerializer() {
        super(XMLNS);
    }

    protected Optional<String> getBpkiElementContent(Document doc, String nodeName) {
        return this.getElement(doc, nodeName).map(e -> e.getTextContent().replaceAll("\\s+", ""));
    }

    protected ProvisioningIdentityCertificate getProvisioningIdentityCertificate(String bpkiTa) {
        ProvisioningIdentityCertificateParser parser = new ProvisioningIdentityCertificateParser();
        parser.parse(ValidationResult.withLocation("unknown.cer"), Base64.getMimeDecoder().decode(bpkiTa));
        return parser.getCertificate();
    }

    public static class IdentitySerializerException
    extends DomXmlSerializerException {
        public IdentitySerializerException(Exception e) {
            super(e);
        }

        public IdentitySerializerException(String message) {
            super(message);
        }

        public IdentitySerializerException(String message, Exception e) {
            super(message, e);
        }
    }
}

