/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.cms;

import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import net.ripe.rpki.commons.provisioning.payload.AbstractProvisioningPayload;
import net.ripe.rpki.commons.util.UTC;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.joda.time.DateTime;

public class ProvisioningCmsObject {
    private byte[] encodedContent;
    private final X509Certificate cmsCertificate;
    private final Collection<X509Certificate> caCertificates;
    private final X509CRL crl;
    private AbstractProvisioningPayload payload;

    public ProvisioningCmsObject(byte[] encodedContent, X509Certificate cmsCertificate, Collection<X509Certificate> caCertificates, X509CRL crl, AbstractProvisioningPayload payload) {
        this.encodedContent = encodedContent;
        this.cmsCertificate = cmsCertificate;
        this.caCertificates = caCertificates;
        this.crl = crl;
        this.payload = payload;
    }

    public byte[] getEncoded() {
        return this.encodedContent;
    }

    public X509Certificate getCmsCertificate() {
        return this.cmsCertificate;
    }

    public AbstractProvisioningPayload getPayload() {
        return this.payload;
    }

    public Collection<X509Certificate> getCaCertificates() {
        return this.caCertificates;
    }

    public X509CRL getCrl() {
        return this.crl;
    }

    public DateTime getSigningTime() {
        try {
            CMSSignedData cmsSignedData = new CMSSignedData(this.encodedContent);
            SignerInformationStore sis = cmsSignedData.getSignerInfos();
            Collection signers = sis.getSigners();
            for (SignerInformation signerInformation : signers) {
                AttributeTable signedAttributes = signerInformation.getSignedAttributes();
                Attribute signingTime = signedAttributes.get(CMSAttributes.signingTime);
                Enumeration en = signingTime.getAttrValues().getObjects();
                while (en.hasMoreElements()) {
                    Object obj = en.nextElement();
                    if (!(obj instanceof DERUTCTime)) continue;
                    DERUTCTime derTime = (DERUTCTime)obj;
                    return UTC.dateTime(derTime.getDate());
                }
            }
            throw new IllegalArgumentException("Malformed encoded cms content");
        }
        catch (ParseException | CMSException e) {
            throw new IllegalArgumentException("Malformed encoded cms content", e);
        }
    }

    public int hashCode() {
        return Arrays.hashCode(this.encodedContent);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProvisioningCmsObject other = (ProvisioningCmsObject)obj;
        return Arrays.equals(this.encodedContent, other.getEncoded());
    }
}

